/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.email;

import com.ivms6.core.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.mail.internet.MimeUtility;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;

public class EmailHikClient {
    private static final int TIME_OUT = 30000;
    private String emailServerAddr;
    private String fromAddr;
    private String userName;
    private String password;
    private String contentType = "text/html;charset=UTF-8";
    private String defaultSubject = "\u672a\u77e5\u4e3b\u9898";

    public EmailHikClient(String emailServerAddr, String fromAddr, String userName, String password) throws NullPointerException {
        if (StringUtils.isBlank((String)emailServerAddr) || StringUtils.isBlank((String)fromAddr) || StringUtils.isBlank((String)userName) || StringUtils.isBlank((String)password)) {
            throw new NullPointerException("\u6784\u9020\u53c2\u6570\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a");
        }
        this.emailServerAddr = emailServerAddr;
        this.fromAddr = fromAddr;
        this.userName = userName;
        this.password = password;
    }

    public String sendText(String subject, String msg, String[] toAddrs) throws EmailException {
        SimpleEmail email = new SimpleEmail();
        email.setSocketTimeout(30000);
        email.setAuthentication(this.userName, this.password);
        email.setHostName(this.emailServerAddr);
        if (toAddrs != null && toAddrs.length > 0) {
            String[] stringArray = toAddrs;
            int n = toAddrs.length;
            int n2 = 0;
            while (n2 < n) {
                String toAddr = stringArray[n2];
                email.addTo(toAddr);
                ++n2;
            }
        } else {
            return null;
        }
        email.setFrom(this.fromAddr);
        if (StringUtils.isBlank((String)subject)) {
            subject = this.defaultSubject;
        }
        email.setSubject(subject);
        email.setContent((Object)msg, this.contentType);
        return email.send();
    }

    public String sendLocalFile(String subject, String msg, String path, String description, String fileName, String[] toAddrs) throws EmailException, UnsupportedEncodingException {
        EmailAttachment attachment = null;
        if (StringUtils.isNotBlank((String)path)) {
            attachment = new EmailAttachment();
            attachment.setPath(path);
            attachment.setDisposition("attachment");
            attachment.setDescription(description);
            if (StringUtils.isBlank((String)fileName)) {
                fileName = path.substring(path.lastIndexOf("/"));
            }
            attachment.setName(MimeUtility.encodeText((String)fileName));
        }
        MultiPartEmail email = new MultiPartEmail();
        email.setSocketTimeout(30000);
        email.updateContentType(this.contentType);
        email.setAuthentication(this.userName, this.password);
        email.setHostName(this.emailServerAddr);
        if (toAddrs != null && toAddrs.length > 0) {
            String[] stringArray = toAddrs;
            int n = toAddrs.length;
            int n2 = 0;
            while (n2 < n) {
                String toAddr = stringArray[n2];
                email.addTo(toAddr);
                ++n2;
            }
        } else {
            return null;
        }
        email.setFrom(this.fromAddr);
        if (StringUtils.isBlank((String)subject)) {
            subject = this.defaultSubject;
        }
        email.setSubject(subject);
        email.setMsg(msg);
        if (attachment != null) {
            email.attach(attachment);
        }
        return email.send();
    }

    public String sendURLFile(String subject, String msg, URL url, String description, String fileName, String[] toAddrs) throws EmailException, UnsupportedEncodingException {
        EmailAttachment attachment = null;
        if (url != null) {
            attachment = new EmailAttachment();
            attachment.setURL(url);
            attachment.setDisposition("attachment");
            attachment.setDescription(description);
            String str = url.toString();
            if (StringUtils.isBlank((String)fileName)) {
                fileName = str.substring(str.lastIndexOf("/"));
            }
            attachment.setName(MimeUtility.encodeText((String)fileName));
        }
        MultiPartEmail email = new MultiPartEmail();
        email.setSocketTimeout(30000);
        email.updateContentType(this.contentType);
        email.setAuthentication(this.userName, this.password);
        email.setHostName(this.emailServerAddr);
        if (toAddrs != null && toAddrs.length > 0) {
            String[] stringArray = toAddrs;
            int n = toAddrs.length;
            int n2 = 0;
            while (n2 < n) {
                String toAddr = stringArray[n2];
                email.addTo(toAddr);
                ++n2;
            }
        } else {
            return null;
        }
        email.setFrom(this.fromAddr);
        if (StringUtils.isBlank((String)subject)) {
            subject = this.defaultSubject;
        }
        email.setSubject(subject);
        email.setMsg(msg);
        if (attachment != null) {
            email.attach(attachment);
        }
        return email.send();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDefaultSubject(String defaultSubject) {
        this.defaultSubject = defaultSubject;
    }
}

