/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.ftp;

import com.ivms6.core.util.IOUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.ftp.FTPErrorCode;
import com.ivms6.core.util.ftp.FTPException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPHikClient {
    private static final Logger log = LoggerFactory.getLogger(FTPHikClient.class);
    private static final int TIME_OUT = 30000;
    private FTPClient ftp = null;
    private String ip;
    private int port;
    private String userName;
    private String password;
    private boolean isLogin = false;

    public FTPHikClient(String ip, int port, String username, String password) throws NullPointerException {
        if (StringUtils.isBlank((String)ip) || port <= 0 || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
            throw new NullPointerException("\u6784\u9020\u53c2\u6570\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a");
        }
        this.ftp = new FTPClient();
        this.ftp.setAutodetectUTF8(true);
        this.ftp.setConnectTimeout(30000);
        this.ip = ip;
        this.port = port;
        this.userName = username;
        this.password = password;
    }

    public void init() throws FTPException {
        this.connect();
        this.isLogin = this.login();
        this.reply();
    }

    public void uploadFile(String path, String filename, InputStream input) throws FTPException {
        try {
            if (!this.changeWorkingDirectory(path)) {
                this.makeDirectory(path);
                this.changeWorkingDirectory(path);
            }
            this.uploadFile(filename, input);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public void downFile(String remotePath, String filename, String localPath) throws FTPException {
        if (!this.changeWorkingDirectory(remotePath)) {
            Object[] args = new Object[]{"username:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u66f4\u6539", remotePath, "\u4e3a\u5de5\u4f5c\u76ee\u5f55\u5931\u8d25..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg);
            ex.setErrorCode(FTPErrorCode.ERR_CHANGE_WORKING_DIRECTORY_FAIL);
            throw ex;
        }
        this.downFile(filename, localPath);
    }

    public InputStream downStream(String remotePath, String filename) throws FTPException {
        if (!this.changeWorkingDirectory(remotePath)) {
            Object[] args = new Object[]{"username:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u66f4\u6539", remotePath, "\u4e3a\u5de5\u4f5c\u76ee\u5f55\u5931\u8d25..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg);
            ex.setErrorCode(FTPErrorCode.ERR_CHANGE_WORKING_DIRECTORY_FAIL);
            throw ex;
        }
        return this.downStream(filename);
    }

    public void createDirectory(String path) throws FTPException {
        if (!this.changeWorkingDirectory(path)) {
            this.makeDirectory(path);
        }
    }

    public void deleteWorkingDirectory(String path) throws FTPException {
        try {
            if (!this.ftp.removeDirectory(path)) {
                Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u5220\u9664", path, "\u76ee\u5f55\u5931\u8d25..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_DELETE_DIRECTORY_FAIL);
                throw ex;
            }
        }
        catch (IOException e) {
            Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u5220\u9664", path, "\u76ee\u5f55\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg, e);
            ex.setErrorCode(FTPErrorCode.ERR_DELETE_DIRECTORY_EXCEPTION);
            throw ex;
        }
    }

    public void deleteWorkingFile(String path, String filename) throws FTPException {
        block4: {
            try {
                if (this.changeWorkingDirectory(path)) {
                    if (!this.ftp.deleteFile(filename)) {
                        Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u5220\u9664", path, "\u76ee\u5f55\u4e0b\u7684", filename, "\u6587\u4ef6\u5931\u8d25..."};
                        String msg = StringUtils.join((Object[])args);
                        FTPException ex = new FTPException(msg);
                        ex.setErrorCode(FTPErrorCode.ERR_DELETE_FILE_FAIL);
                        throw ex;
                    }
                    break block4;
                }
                Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u66f4\u6539", path, "\u4e3a\u5de5\u4f5c\u76ee\u5f55\u5931\u8d25..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_CHANGE_WORKING_DIRECTORY_FAIL);
                throw ex;
            }
            catch (IOException e) {
                Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u5220\u9664", path, "\u76ee\u5f55\u4e0b\u7684", filename, "\u6587\u4ef6\u5f02\u5e38..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg, e);
                ex.setErrorCode(FTPErrorCode.ERR_DELETE_FILE_EXCEPTION);
                throw ex;
            }
        }
    }

    private boolean changeWorkingDirectory(String path) throws FTPException {
        try {
            if (this.ftp.changeWorkingDirectory(path)) {
                Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u66f4\u6539", path, "\u4e3a\u5de5\u4f5c\u76ee\u5f55\u5931\u8d25..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_CHANGE_WORKING_DIRECTORY_FAIL);
                throw ex;
            }
            return true;
        }
        catch (IOException e) {
            Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u66f4\u6539", path, "\u4e3a\u5de5\u4f5c\u76ee\u5f55\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg, e);
            ex.setErrorCode(FTPErrorCode.ERR_CHANGE_WORKING_DIRECTORY_EXCEPTION);
            throw ex;
        }
    }

    public void close() throws FTPException {
        if (this.isLogin) {
            this.logout();
        }
        this.disconnect();
    }

    private void connect() throws FTPException {
        try {
            this.ftp.connect(this.ip, this.port);
            Object[] args = new Object[]{"\u6253\u5f00FTP:", this.ip, ":", this.port, "\u8fde\u63a5..."};
            String msg = StringUtils.join((Object[])args);
            log.info(msg);
        }
        catch (SocketException e) {
            Object[] args = new Object[]{"FTP:", this.ip, ":", this.port, "\u6253\u5f00\u8fde\u63a5SOCKET\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg, e);
            ex.setErrorCode(FTPErrorCode.ERR_CONNECT_EXCEPTION);
            throw ex;
        }
        catch (IOException e) {
            Object[] args = new Object[]{"FTP:", this.ip, ":", this.port, "\u6253\u5f00\u8fde\u63a5IO\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg, e);
            ex.setErrorCode(FTPErrorCode.ERR_CONNECT_EXCEPTION);
            throw ex;
        }
    }

    private boolean login() throws FTPException {
        try {
            boolean isLogin = this.ftp.login(this.userName, this.password);
            if (!isLogin) {
                Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u5931\u8d25..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_LOG_IN_FAIL);
                throw ex;
            }
            return isLogin;
        }
        catch (IOException e) {
            Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg, e);
            ex.setErrorCode(FTPErrorCode.ERR_LOG_IN_EXCEPTION);
            throw ex;
        }
    }

    private void reply() throws FTPException {
        if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
            Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u5e94\u7b54\u4e0d\u79ef\u6781..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg);
            ex.setErrorCode(FTPErrorCode.ERR_NOT_REPLY);
            throw ex;
        }
    }

    private void makeDirectory(String path) throws FTPException {
        try {
            if (!this.ftp.makeDirectory(path)) {
                Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u521b\u5efa", path, "\u76ee\u5f55\u5931\u8d25..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_MARK_DIRECTORY_FAIL);
                throw ex;
            }
        }
        catch (IOException e) {
            Object[] args = new Object[]{"userName:", this.userName, " \u767b\u5f55FTP:", this.ip, ":", this.port, "\u521b\u5efa", path, "\u76ee\u5f55\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg, e);
            ex.setErrorCode(FTPErrorCode.ERR_MARK_DIRECTORY_EXCEPTION);
            throw ex;
        }
    }

    private void uploadFile(String filename, InputStream input) throws FTPException {
        try {
            boolean flag = this.ftp.storeFile(filename, input);
            if (!flag) {
                Object[] args = new Object[]{"userName:", this.userName, "\u767b\u5f55FTP:", this.ip, ":", this.port, "\u4e0a\u4f20", filename, "\u6587\u4ef6\u5931\u8d25..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_UPLOAD_FILE_FAIL);
                throw ex;
            }
        }
        catch (IOException e) {
            Object[] args = new Object[]{"userName:", this.userName, "\u767b\u5f55FTP:", this.ip, ":", this.port, "\u4e0a\u4f20", filename, "\u6587\u4ef6\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg, e);
            ex.setErrorCode(FTPErrorCode.ERR_UPLOAD_FILE_EXCEPTION);
            throw ex;
        }
    }

    /*
     * Exception decompiling
     */
    private InputStream downStream(String filename) throws FTPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void downFile(String filename, String localPath) throws FTPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logout() throws FTPException {
        try {
            if (!this.ftp.logout()) {
                Object[] args = new Object[]{"userName:", this.userName, "\u9000\u51faFTP:", this.ip, ":", this.port, "\u5931\u8d25..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_LOG_OUT_FAIL);
                throw ex;
            }
        }
        catch (IOException e) {
            Object[] args = new Object[]{"userName:", this.userName, "\u9000\u51faFTP:", this.ip, ":", this.port, "\u5f02\u5e38..."};
            String msg = StringUtils.join((Object[])args);
            FTPException ex = new FTPException(msg);
            ex.setErrorCode(FTPErrorCode.ERR_LOG_OUT_EXCEPTION);
            throw ex;
        }
    }

    private void disconnect() throws FTPException {
        if (this.ftp.isConnected()) {
            try {
                Object[] args = new Object[]{"\u5173\u95edFTP:", this.ip, ":", this.port, "\u8fde\u63a5..."};
                String msg = StringUtils.join((Object[])args);
                log.info(msg);
                this.ftp.disconnect();
            }
            catch (IOException e) {
                Object[] args = new Object[]{"FTP:", this.ip, ":", this.port, "\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38..."};
                String msg = StringUtils.join((Object[])args);
                FTPException ex = new FTPException(msg);
                ex.setErrorCode(FTPErrorCode.ERR_DIS_CONNECT_EXCEPTION);
                throw ex;
            }
        }
    }
}

