/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.axiom.locator.DefaultLoader;
import org.apache.axiom.locator.Implementation;
import org.apache.axiom.locator.ImplementationFactory;
import org.apache.axiom.locator.PriorityBasedOMMetaFactoryLocator;

public final class DefaultOMMetaFactoryLocator
extends PriorityBasedOMMetaFactoryLocator {
    public DefaultOMMetaFactoryLocator() {
        Implementation implementation;
        ClassLoader classLoader = DefaultOMMetaFactoryLocator.class.getClassLoader();
        DefaultLoader loader = new DefaultLoader(classLoader);
        ArrayList<Implementation> implementations = new ArrayList<Implementation>();
        String metaFactoryClassName = null;
        try {
            metaFactoryClassName = System.getProperty("org.apache.axiom.om.OMMetaFactory");
            if ("".equals(metaFactoryClassName)) {
                metaFactoryClassName = null;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (metaFactoryClassName != null && (implementation = ImplementationFactory.createDefaultImplementation(loader, metaFactoryClassName)) != null) {
            implementations.add(implementation);
        }
        try {
            Enumeration<URL> e = classLoader.getResources("META-INF/axiom.xml");
            while (e.hasMoreElements()) {
                implementations.addAll(ImplementationFactory.parseDescriptor(loader, e.nextElement()));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.loadImplementations(implementations);
    }
}

