/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

class GUIDGenerator {
    private static String MACHINE_DESCRIPTOR = GUIDGenerator.getMachineDescriptor();

    GUIDGenerator() {
    }

    public static String generate() {
        StringBuffer id = new StringBuffer();
        GUIDGenerator.encode(id, MACHINE_DESCRIPTOR);
        GUIDGenerator.encode(id, Runtime.getRuntime());
        GUIDGenerator.encode(id, Thread.currentThread());
        GUIDGenerator.encode(id, System.currentTimeMillis());
        GUIDGenerator.encode(id, GUIDGenerator.getRandomInt());
        return id.toString();
    }

    private static String getMachineDescriptor() {
        StringBuffer descriptor = new StringBuffer();
        descriptor.append(System.getProperty("os.name"));
        descriptor.append("::");
        descriptor.append(System.getProperty("os.arch"));
        descriptor.append("::");
        descriptor.append(System.getProperty("os.version"));
        descriptor.append("::");
        descriptor.append(System.getProperty("user.name"));
        descriptor.append("::");
        StringBuffer b = GUIDGenerator.buildNetworkInterfaceDescriptor();
        if (b != null) {
            descriptor.append(b);
        } else {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                descriptor.append(addr.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return descriptor.toString();
    }

    private static StringBuffer buildNetworkInterfaceDescriptor() {
        Enumeration<NetworkInterface> e1;
        try {
            e1 = NetworkInterface.getNetworkInterfaces();
        }
        catch (Throwable t) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        while (e1.hasMoreElements()) {
            NetworkInterface ni = e1.nextElement();
            StringBuffer b1 = GUIDGenerator.getMACAddressDescriptor(ni);
            StringBuffer b2 = GUIDGenerator.getInetAddressDescriptor(ni);
            StringBuffer b3 = new StringBuffer();
            if (b1 != null) {
                b3.append(b1);
            }
            if (b2 != null) {
                if (b3.length() > 0) {
                    b3.append('=');
                }
                b3.append(b2);
            }
            if (b3.length() <= 0) continue;
            if (b.length() > 0) {
                b.append(';');
            }
            b.append(b3);
        }
        return b;
    }

    private static StringBuffer getMACAddressDescriptor(NetworkInterface ni) {
        byte[] haddr;
        try {
            haddr = ni.getHardwareAddress();
        }
        catch (Throwable t) {
            haddr = null;
        }
        StringBuffer b = new StringBuffer();
        if (haddr != null) {
            int i = 0;
            while (i < haddr.length) {
                String hex;
                if (b.length() > 0) {
                    b.append("-");
                }
                if ((hex = Integer.toHexString(0xFF & haddr[i])).length() == 1) {
                    b.append('0');
                }
                b.append(hex);
                ++i;
            }
        }
        return b;
    }

    private static StringBuffer getInetAddressDescriptor(NetworkInterface ni) {
        StringBuffer b = new StringBuffer();
        Enumeration<InetAddress> e2 = ni.getInetAddresses();
        while (e2.hasMoreElements()) {
            InetAddress addr = e2.nextElement();
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(addr.getHostAddress());
        }
        return b;
    }

    private static int getRandomInt() {
        return (int)Math.round(Math.random() * 2.147483647E9);
    }

    private static void encode(StringBuffer b, Object obj) {
        GUIDGenerator.encode(b, obj.hashCode());
    }

    private static void encode(StringBuffer b, int value) {
        String hex = Integer.toHexString(value);
        int hexSize = hex.length();
        int i = 8;
        while (i > hexSize) {
            b.append('0');
            --i;
        }
        b.append(hex);
    }

    private static void encode(StringBuffer b, long value) {
        String hex = Long.toHexString(value);
        int hexSize = hex.length();
        int i = 16;
        while (i > hexSize) {
            b.append('0');
            --i;
        }
        b.append(hex);
    }
}

