/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import com.ivms6.core.scheduler.Task;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class MemoryTaskCollector {
    private Map<String, Task> taskmap = new ConcurrentHashMap<String, Task>();

    MemoryTaskCollector() {
    }

    public int size() {
        return this.taskmap.size();
    }

    public String add(Task task) {
        this.taskmap.put(task.getId(), task);
        return task.getId();
    }

    public void update(String id, String pattern) {
        Task t = this.taskmap.get(id);
        if (t != null) {
            t.setSchedulingPattern(pattern);
        }
    }

    public void remove(String id) throws IndexOutOfBoundsException {
        this.taskmap.remove(id);
    }

    public Task getTask(String id) {
        return this.taskmap.get(id);
    }

    public Collection<Task> getTasks() {
        return this.taskmap.values();
    }

    public boolean isEmpty() {
        return this.taskmap.isEmpty();
    }
}

