/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import com.ivms6.core.scheduler.GUIDGenerator;
import com.ivms6.core.scheduler.ITaskEntity;
import com.ivms6.core.scheduler.InvalidPatternException;
import com.ivms6.core.scheduler.MemoryTaskCollector;
import com.ivms6.core.scheduler.SchedulingPattern;
import com.ivms6.core.scheduler.Task;
import com.ivms6.core.scheduler.TaskContext;
import com.ivms6.core.scheduler.TaskExecutor;
import com.ivms6.core.scheduler.TimerDaemon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    private String guid = GUIDGenerator.generate();
    private TimeZone timezone = null;
    private boolean started = false;
    private MemoryTaskCollector memoryTaskCollector = new MemoryTaskCollector();
    private TimerDaemon timer = null;
    private ArrayList<TaskExecutor> executors = null;
    private Executor executor;
    private Object lock = new Object();

    public Scheduler() {
    }

    public Scheduler(Executor executor) {
        this.executor = executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Object getGuid() {
        return this.guid;
    }

    public void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public TimeZone getTimeZone() {
        return this.timezone != null ? this.timezone : TimeZone.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.lock;
        synchronized (object) {
            return this.started;
        }
    }

    public String schedule(ITaskEntity task) throws InvalidPatternException {
        if (task != null && task.getSchedulingPattern() != null) {
            return this.schedule(new Task(task));
        }
        return null;
    }

    private String schedule(Task task) {
        return this.memoryTaskCollector.add(task);
    }

    public void reschedule(String id, String schedulingPattern) throws InvalidPatternException {
        this.memoryTaskCollector.update(id, schedulingPattern);
    }

    public void deschedule(String id) {
        this.memoryTaskCollector.remove(id);
    }

    public ITaskEntity getTask(String id) {
        Task task = this.memoryTaskCollector.getTask(id);
        if (task == null) {
            return null;
        }
        return task.getTaskEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Scheduler already started");
            }
            this.executors = new ArrayList();
            this.timer = new TimerDaemon(this);
            this.timer.start();
            this.started = true;
        }
    }

    public void joinTimer(long millis) throws InterruptedException {
        if (!this.started) {
            throw new IllegalStateException("Scheduler not started");
        }
        if (this.timer != null) {
            this.timer.join(millis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started");
            }
            if (this.timer != null) {
                this.timer.interrupt();
            }
            this.timer = null;
            for (TaskExecutor executor : this.executors) {
                executor.join();
            }
            this.executors.clear();
            this.started = false;
        }
    }

    void spawnLauncher(long referenceTimeInMillis) {
        if (this.memoryTaskCollector.isEmpty()) {
            return;
        }
        LOG.trace("scheduler spawnLaucher referenceTimeInMillis:{}, task size:{}", (Object)referenceTimeInMillis, (Object)this.memoryTaskCollector.size());
        for (Task task : this.memoryTaskCollector.getTasks()) {
            try {
                SchedulingPattern pattern = task.getSchedulingPattern();
                if (!task.isRuning() && pattern.match(this.getTimeZone(), referenceTimeInMillis)) {
                    this.spawnExecutor(task, referenceTimeInMillis);
                    continue;
                }
                if (!pattern.match(this.getTimeZone(), referenceTimeInMillis)) continue;
                LOG.info("scheduler task[{}] is running!", (Object)task.getId());
            }
            catch (Exception e) {
                LOG.error("spawnExecutor Exception:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void spawnExecutor(Task task, long referenceTimeInMillis) {
        if (task == null) {
            return;
        }
        task.currentFireTime = referenceTimeInMillis;
        TaskExecutor e = new TaskExecutor(this, task);
        if (this.executors != null) {
            ArrayList<TaskExecutor> arrayList = this.executors;
            synchronized (arrayList) {
                this.executors.add(e);
            }
        }
        if (this.executor == null) {
            e.start();
        } else {
            this.executor.execute(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExecutor(TaskExecutor executor) {
        if (this.executors != null) {
            ArrayList<TaskExecutor> arrayList = this.executors;
            synchronized (arrayList) {
                this.executors.remove(executor);
            }
        }
    }

    public List<TaskContext> getTaskContexts() {
        Task[] tasks = this.memoryTaskCollector.getTasks().toArray(new Task[this.memoryTaskCollector.size()]);
        return Arrays.asList(tasks);
    }
}

