/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import com.ivms6.core.scheduler.ITaskEntity;
import com.ivms6.core.scheduler.InvalidPatternException;
import com.ivms6.core.scheduler.Scheduler;
import com.ivms6.core.util.ClassLoaderUtil;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.IOUtils;
import com.ivms6.core.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.lang.BooleanUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerFactory {
    private static final Logger log = LoggerFactory.getLogger(SchedulerFactory.class);
    private final Scheduler scheduler = new Scheduler();

    /*
     * Loose catch block
     */
    private boolean load(String taskfile) {
        List nodes;
        Document document = null;
        InputStream is = null;
        try {
            try {
                is = ClassLoaderUtil.getStream((String)taskfile);
                SAXReader reader = new SAXReader();
                document = reader.read(is);
            }
            catch (MalformedURLException e) {
                log.error(String.valueOf(taskfile) + "\u8def\u5f84\u88c5URL\u5f02\u5e38\uff01", (Throwable)e);
                IOUtils.closeQuietly((InputStream)is);
                return false;
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6" + taskfile + "\u6587\u4ef6\u7684IO\u5f02\u5e38", (Throwable)e);
                IOUtils.closeQuietly((InputStream)is);
                return false;
            }
            catch (DocumentException e) {
                log.error("\u89e3\u6790" + taskfile + "\u7684xml\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
                return false;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        if (document != null && CollectionUtils.isNotEmpty((Collection)(nodes = document.selectNodes("/tasks/task")))) {
            for (Node node : nodes) {
                String taskId = node.valueOf("@id");
                String enable = node.valueOf("@enable");
                String pattern = node.valueOf("@pattern");
                String className = node.valueOf("@class");
                if (this.scheduler.getTask(taskId) != null) {
                    log.error("\u5b58\u5728\u76f8\u540c\u7684\u4efb\u52a1ID\uff1a" + taskId);
                    return false;
                }
                if (!StringUtils.isNotBlank((String)enable) || !BooleanUtils.toBoolean((String)enable)) continue;
                try {
                    ITaskEntity taskEntity = (ITaskEntity)Class.forName(className).newInstance();
                    taskEntity.setSchedulingPattern(pattern);
                    taskEntity.setTaskId(taskId);
                    this.scheduler.schedule(taskEntity);
                }
                catch (InvalidPatternException e) {
                    log.error("\u65e0\u6548\u7684\u8c03\u5ea6\u6a21\u5f0f\u5f02\u5e38", (Throwable)e);
                    return false;
                }
                catch (InstantiationException e) {
                    log.error(String.valueOf(className) + "\u5b9e\u4f8b\u5316\u5f02\u5e38", (Throwable)e);
                    return false;
                }
                catch (IllegalAccessException e) {
                    log.error(String.valueOf(className) + "\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
                    return false;
                }
                catch (ClassNotFoundException e) {
                    log.error("\u65e0\u6cd5\u627e\u5230" + className + "\u7c7b\u7684\u5f02\u5e38", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    public void setExecutor(Executor executor) {
        this.scheduler.setExecutor(executor);
    }

    public void reschedule(String id, String schedulingPattern) {
        this.scheduler.reschedule(id, schedulingPattern);
    }

    public void deschedule(String id) {
        this.scheduler.deschedule(id);
    }

    public boolean start() {
        if (!this.scheduler.isStarted()) {
            this.scheduler.start();
            return true;
        }
        return false;
    }

    public boolean start(String filePath) {
        if (!this.scheduler.isStarted() && this.load(filePath)) {
            this.scheduler.start();
            return true;
        }
        return false;
    }

    public void addTask(ITaskEntity ... tasks) {
        if (tasks != null && tasks.length > 0) {
            ITaskEntity[] iTaskEntityArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                ITaskEntity taskEntity = iTaskEntityArray[n2];
                try {
                    this.scheduler.schedule(taskEntity);
                }
                catch (InvalidPatternException e) {
                    log.error("\u65e0\u6548\u7684\u8c03\u5ea6\u6a21\u5f0f\u5f02\u5e38", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public boolean start(ITaskEntity ... tasks) {
        if (!this.scheduler.isStarted()) {
            this.addTask(tasks);
            this.scheduler.start();
            return true;
        }
        return false;
    }

    public boolean restart() {
        if (!this.scheduler.isStarted()) {
            this.scheduler.start();
            return true;
        }
        return false;
    }

    public boolean stop() {
        if (this.scheduler.isStarted()) {
            try {
                this.scheduler.stop();
            }
            catch (IllegalStateException e) {
                log.error("\u4efb\u52a1\u8c03\u5ea6\u975e\u6cd5\u72b6\u6001\u7684\u5f02\u5e38", (Throwable)e);
                return false;
            }
            catch (InterruptedException e) {
                log.error("\u4efb\u52a1\u8c03\u5ea6\u6b63\u5728\u6267\u884c\u7684\u7ebf\u7a0b\u88ab\u4e2d\u65ad\u5f02\u5e38", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

