/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import com.ivms6.core.scheduler.AlwaysTrueValueMatcher;
import com.ivms6.core.scheduler.DayOfMonthValueMatcher;
import com.ivms6.core.scheduler.IntArrayValueMatcher;
import com.ivms6.core.scheduler.InvalidPatternException;
import com.ivms6.core.scheduler.ValueMatcher;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

class SchedulingPattern {
    private static final ValueParser SECOND_VALUE_PARSER = new SecondValueParser();
    private static final ValueParser MINUTE_VALUE_PARSER = new MinuteValueParser();
    private static final ValueParser HOUR_VALUE_PARSER = new HourValueParser();
    private static final ValueParser DAY_OF_MONTH_VALUE_PARSER = new DayOfMonthValueParser();
    private static final ValueParser MONTH_VALUE_PARSER = new MonthValueParser();
    private static final ValueParser DAY_OF_WEEK_VALUE_PARSER = new DayOfWeekValueParser();
    private String asString;
    protected ArrayList<ValueMatcher> secondMatchers = new ArrayList<E>();
    protected ArrayList<ValueMatcher> minuteMatchers = new ArrayList<E>();
    protected ArrayList<ValueMatcher> hourMatchers = new ArrayList<E>();
    protected ArrayList<ValueMatcher> dayOfMonthMatchers = new ArrayList<E>();
    protected ArrayList<ValueMatcher> monthMatchers = new ArrayList<E>();
    protected ArrayList<ValueMatcher> dayOfWeekMatchers = new ArrayList<E>();
    protected int matcherSize = 0;

    public static boolean validate(String schedulingPattern) {
        try {
            new SchedulingPattern(schedulingPattern);
        }
        catch (InvalidPatternException e) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public SchedulingPattern(String pattern) throws InvalidPatternException {
        super();
        this.asString = pattern;
        st1 = new StringTokenizer(pattern, "|");
        if (st1.countTokens() >= 1) ** GOTO lbl54
        throw new InvalidPatternException("invalid pattern: \"" + pattern + "\"");
lbl-1000:
        // 1 sources

        {
            localPattern = st1.nextToken();
            st2 = new StringTokenizer(localPattern, " \t");
            if (st2.countTokens() != 6) {
                throw new InvalidPatternException("invalid pattern: \"" + localPattern + "\"");
            }
            try {
                this.secondMatchers.add(this.buildValueMatcher(st2.nextToken(), SchedulingPattern.SECOND_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new InvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing second field: " + e.getMessage() + ".");
            }
            try {
                this.minuteMatchers.add(this.buildValueMatcher(st2.nextToken(), SchedulingPattern.MINUTE_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new InvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing minutes field: " + e.getMessage() + ".");
            }
            try {
                this.hourMatchers.add(this.buildValueMatcher(st2.nextToken(), SchedulingPattern.HOUR_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new InvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing hours field: " + e.getMessage() + ".");
            }
            try {
                this.dayOfMonthMatchers.add(this.buildValueMatcher(st2.nextToken(), SchedulingPattern.DAY_OF_MONTH_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new InvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing days of month field: " + e.getMessage() + ".");
            }
            try {
                this.monthMatchers.add(this.buildValueMatcher(st2.nextToken(), SchedulingPattern.MONTH_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new InvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing months field: " + e.getMessage() + ".");
            }
            try {
                this.dayOfWeekMatchers.add(this.buildValueMatcher(st2.nextToken(), SchedulingPattern.DAY_OF_WEEK_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new InvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing days of week field: " + e.getMessage() + ".");
            }
            ++this.matcherSize;
lbl54:
            // 2 sources

            ** while (st1.hasMoreTokens())
        }
lbl55:
        // 1 sources

    }

    private ValueMatcher buildValueMatcher(String str, ValueParser parser) throws Exception {
        if (str.length() == 1 && str.equals("*")) {
            return new AlwaysTrueValueMatcher();
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            ArrayList<Integer> local;
            String element = st.nextToken();
            try {
                local = this.parseListElement(element, parser);
            }
            catch (Exception e) {
                throw new Exception("invalid field \"" + str + "\", invalid element \"" + element + "\", " + e.getMessage());
            }
            for (Integer value : local) {
                if (values.contains(value)) continue;
                values.add(value);
            }
        }
        if (values.size() == 0) {
            throw new Exception("invalid field \"" + str + "\"");
        }
        if (parser == DAY_OF_MONTH_VALUE_PARSER) {
            return new DayOfMonthValueMatcher(values);
        }
        return new IntArrayValueMatcher(values);
    }

    private ArrayList<Integer> parseListElement(String str, ValueParser parser) throws Exception {
        ArrayList<Integer> values;
        StringTokenizer st = new StringTokenizer(str, "/");
        int size = st.countTokens();
        if (size < 1 || size > 2) {
            throw new Exception("syntax error");
        }
        try {
            values = this.parseRange(st.nextToken(), parser);
        }
        catch (Exception e) {
            throw new Exception("invalid range, " + e.getMessage());
        }
        if (size == 2) {
            int div;
            String dStr = st.nextToken();
            try {
                div = Integer.parseInt(dStr);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid divisor \"" + dStr + "\"");
            }
            if (div < 1) {
                throw new Exception("non positive divisor \"" + div + "\"");
            }
            ArrayList<Integer> values2 = new ArrayList<Integer>();
            int i = 0;
            while (i < values.size()) {
                values2.add(values.get(i));
                i += div;
            }
            return values2;
        }
        return values;
    }

    private ArrayList<Integer> parseRange(String str, ValueParser parser) throws Exception {
        int v2;
        int v1;
        if (str.equals("*")) {
            int min = parser.getMinValue();
            int max = parser.getMaxValue();
            ArrayList<Integer> values = new ArrayList<Integer>();
            int i = min;
            while (i <= max) {
                values.add(i);
                ++i;
            }
            return values;
        }
        StringTokenizer st = new StringTokenizer(str, "-");
        int size = st.countTokens();
        if (size < 1 || size > 2) {
            throw new Exception("syntax error");
        }
        String v1Str = st.nextToken();
        try {
            v1 = parser.parse(v1Str);
        }
        catch (Exception e) {
            throw new Exception("invalid value \"" + v1Str + "\", " + e.getMessage());
        }
        if (size == 1) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(v1);
            return values;
        }
        String v2Str = st.nextToken();
        try {
            v2 = parser.parse(v2Str);
        }
        catch (Exception e) {
            throw new Exception("invalid value \"" + v2Str + "\", " + e.getMessage());
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (v1 < v2) {
            int i = v1;
            while (i <= v2) {
                values.add(i);
                ++i;
            }
        } else if (v1 > v2) {
            int min = parser.getMinValue();
            int max = parser.getMaxValue();
            int i = v1;
            while (i <= max) {
                values.add(i);
                ++i;
            }
            i = min;
            while (i <= v2) {
                values.add(i);
                ++i;
            }
        } else {
            values.add(v1);
        }
        return values;
    }

    public boolean match(TimeZone timezone, long millis) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(millis);
        gc.setTimeZone(timezone);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hour = gc.get(11);
        int dayOfMonth = gc.get(5);
        int month = gc.get(2) + 1;
        int dayOfWeek = gc.get(7) - 1;
        int year = gc.get(1);
        int i = 0;
        while (i < this.matcherSize) {
            boolean eval;
            ValueMatcher secondMatcher = this.secondMatchers.get(i);
            ValueMatcher minuteMatcher = this.minuteMatchers.get(i);
            ValueMatcher hourMatcher = this.hourMatchers.get(i);
            ValueMatcher dayOfMonthMatcher = this.dayOfMonthMatchers.get(i);
            ValueMatcher monthMatcher = this.monthMatchers.get(i);
            ValueMatcher dayOfWeekMatcher = this.dayOfWeekMatchers.get(i);
            boolean bl = secondMatcher.match(second) && minuteMatcher.match(minute) && hourMatcher.match(hour) && (dayOfMonthMatcher instanceof DayOfMonthValueMatcher ? ((DayOfMonthValueMatcher)dayOfMonthMatcher).match(dayOfMonth, month, gc.isLeapYear(year)) : dayOfMonthMatcher.match(dayOfMonth)) && monthMatcher.match(month) && dayOfWeekMatcher.match(dayOfWeek) ? true : (eval = false);
            if (eval) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean match(long millis) {
        return this.match(TimeZone.getDefault(), millis);
    }

    public String toString() {
        return this.asString;
    }

    private static int parseAlias(String value, String[] aliases, int offset) throws Exception {
        int i = 0;
        while (i < aliases.length) {
            if (aliases[i].equalsIgnoreCase(value)) {
                return offset + i;
            }
            ++i;
        }
        throw new Exception("invalid alias \"" + value + "\"");
    }

    private static class DayOfMonthValueParser
    extends SimpleValueParser {
        public DayOfMonthValueParser() {
            super(1, 31);
        }

        @Override
        public int parse(String value) throws Exception {
            if (value.equalsIgnoreCase("L")) {
                return 32;
            }
            return super.parse(value);
        }
    }

    private static class DayOfWeekValueParser
    extends SimpleValueParser {
        private static String[] ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};

        public DayOfWeekValueParser() {
            super(0, 7);
        }

        @Override
        public int parse(String value) throws Exception {
            try {
                return super.parse(value) % 7;
            }
            catch (Exception e) {
                return SchedulingPattern.parseAlias(value, DayOfWeekValueParser.ALIASES, 0);
            }
        }
    }

    private static class HourValueParser
    extends SimpleValueParser {
        public HourValueParser() {
            super(0, 23);
        }
    }

    private static class MinuteValueParser
    extends SimpleValueParser {
        public MinuteValueParser() {
            super(0, 59);
        }
    }

    private static class MonthValueParser
    extends SimpleValueParser {
        private static String[] ALIASES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

        public MonthValueParser() {
            super(1, 12);
        }

        @Override
        public int parse(String value) throws Exception {
            try {
                return super.parse(value);
            }
            catch (Exception e) {
                return SchedulingPattern.parseAlias(value, MonthValueParser.ALIASES, 1);
            }
        }
    }

    private static class SecondValueParser
    extends SimpleValueParser {
        public SecondValueParser() {
            super(0, 59);
        }
    }

    private static class SimpleValueParser
    implements ValueParser {
        protected int minValue;
        protected int maxValue;

        public SimpleValueParser(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public int parse(String value) throws Exception {
            int i;
            try {
                i = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid integer value");
            }
            if (i < this.minValue || i > this.maxValue) {
                throw new Exception("value out of range");
            }
            return i;
        }

        @Override
        public int getMinValue() {
            return this.minValue;
        }

        @Override
        public int getMaxValue() {
            return this.maxValue;
        }
    }

    private static interface ValueParser {
        public int parse(String var1) throws Exception;

        public int getMinValue();

        public int getMaxValue();
    }
}

