/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import com.ivms6.core.scheduler.GUIDGenerator;
import com.ivms6.core.scheduler.ITaskEntity;
import com.ivms6.core.scheduler.InvalidPatternException;
import com.ivms6.core.scheduler.SchedulingPattern;
import com.ivms6.core.scheduler.TaskContext;
import com.ivms6.core.scheduler.TaskContextListener;
import com.ivms6.core.util.StringUtils;
import java.util.concurrent.atomic.AtomicInteger;

final class Task
implements TaskContext {
    private ITaskEntity taskEntity;
    long currentFireTime;
    long lastFireTime;
    long lastFirePeriod;
    private Throwable lastException;
    private volatile boolean isRuning = false;
    private AtomicInteger count = new AtomicInteger();
    private SchedulingPattern pattern;
    private long start;

    public Task(ITaskEntity taskEntity) throws InvalidPatternException {
        if (taskEntity == null) {
            throw new NullPointerException("Can not input a null task entity!");
        }
        this.taskEntity = taskEntity;
        if (StringUtils.isBlank((String)taskEntity.getTaskId())) {
            taskEntity.setTaskId(GUIDGenerator.generate());
        }
        this.pattern = new SchedulingPattern(taskEntity.getSchedulingPattern());
        if (taskEntity instanceof TaskContextListener) {
            ((TaskContextListener)taskEntity).setTaskContext(this);
        }
    }

    public SchedulingPattern getSchedulingPattern() {
        return this.pattern;
    }

    @Override
    public void setSchedulingPattern(String schedulingPattern) {
        this.taskEntity.setSchedulingPattern(schedulingPattern);
        this.pattern = new SchedulingPattern(schedulingPattern);
    }

    @Override
    public ITaskEntity getTaskEntity() {
        return this.taskEntity;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    public void execute() {
        if (!this.isRuning && this.taskEntity != null) {
            this.isRuning = true;
            this.count.incrementAndGet();
            this.start = System.currentTimeMillis();
            try {
                try {
                    this.taskEntity.run();
                    this.lastException = null;
                }
                catch (RuntimeException e) {
                    this.lastException = e;
                    throw e;
                }
                catch (Error e) {
                    this.lastException = e;
                    throw e;
                }
            }
            finally {
                this.lastFireTime = this.currentFireTime;
                this.lastFirePeriod = System.currentTimeMillis() - this.start;
                this.isRuning = false;
                this.start = 0L;
            }
        }
    }

    @Override
    public String getId() {
        return this.taskEntity.getTaskId();
    }

    @Override
    public boolean isRuning() {
        return this.isRuning;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Task[");
        b.append("taskEntity=");
        b.append(this.taskEntity);
        b.append("]");
        return b.toString();
    }

    @Override
    public long getReferenceTimeInMillis() {
        return this.currentFireTime;
    }

    @Override
    public int getExecuteTimes() {
        return this.count.get();
    }

    @Override
    public long getLastFireTime() {
        return this.lastFireTime;
    }

    @Override
    public long getLastPeriod() {
        return this.lastFirePeriod;
    }

    @Override
    public boolean isLastSuccess() {
        return this.lastException == null;
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }
}

