/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import com.ivms6.core.scheduler.GUIDGenerator;
import com.ivms6.core.scheduler.Scheduler;
import com.ivms6.core.scheduler.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TaskExecutor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutor.class);
    private Task task;
    private Scheduler scheduler;
    private String guid = GUIDGenerator.generate();
    private volatile transient Thread inThread;
    private Object lock = new Object();

    TaskExecutor(Scheduler scheduler, Task task) {
        this.scheduler = scheduler;
        this.task = task;
    }

    public String getGuid() {
        return this.guid;
    }

    public Task getTask() {
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            block8: {
                this.inThread = Thread.currentThread();
                try {
                    try {
                        this.task.execute();
                    }
                    catch (Throwable e) {
                        LOG.error("task error,task id=" + this.task.getId(), e);
                        this.scheduler.removeExecutor(this);
                        this.inThread = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.scheduler.removeExecutor(this);
                    this.inThread = null;
                    throw throwable;
                }
                this.scheduler.removeExecutor(this);
                this.inThread = null;
            }
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setName("[Task" + this.getGuid() + "]");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        while (this.inThread != null) {
            Object object = this.lock;
            synchronized (object) {
                System.out.println();
            }
        }
    }
}

