/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.scheduler;

import com.ivms6.core.scheduler.GUIDGenerator;
import com.ivms6.core.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimerDaemon
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(TimerDaemon.class);
    private String guid = GUIDGenerator.generate();
    private Scheduler scheduler;

    public TimerDaemon(Scheduler scheduler) {
        this.scheduler = scheduler;
        String name = "hik::scheduler-" + scheduler.getGuid();
        this.setName(name);
    }

    public Object getGuid() {
        return this.guid;
    }

    @Override
    public void run() {
        long lastSecond = System.currentTimeMillis();
        while (true) {
            long sleepTime;
            long nextSecond;
            if ((nextSecond = (System.currentTimeMillis() / 1000L + 1L) * 1000L) == lastSecond) {
                nextSecond += 1000L;
            } else {
                long interval = nextSecond - lastSecond;
                if (interval > 1000L && interval < 10000L) {
                    long lostSecond = lastSecond + 1000L;
                    while (lostSecond < nextSecond) {
                        this.scheduler.spawnLauncher(lostSecond);
                        lastSecond = lostSecond;
                        lostSecond += 1000L;
                    }
                }
            }
            if ((sleepTime = nextSecond - System.currentTimeMillis()) > 1000L) continue;
            if (sleepTime > 0L) {
                try {
                    TimerDaemon.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    LOG.error("latch.await InterruptedException", (Throwable)e);
                    break;
                }
            }
            this.scheduler.spawnLauncher(nextSecond);
            lastSecond = nextSecond;
        }
    }
}

