package com.yeejoin.amos;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

import com.yeejoin.amos.rtsp.HtmlRtspPlayerWebSockerServer;
import com.yeejoin.amos.rtsp.WebSocketHandshakeInterceptor;

@EnableScheduling
@EnableWebSocket
@SpringBootApplication
//@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class})
@ImportResource(locations = {"classpath:config/applicationXml/application-*.xml"})
@MapperScan(basePackages ={"com.yeejoin.amos.mapper"})
public class AppStart 
implements WebSocketConfigurer
{
	
	public static void main(String[] args) {
		new SpringApplication(AppStart.class).run(args);
	}

    @Bean
    public HtmlRtspPlayerWebSockerServer htmlRtspPlayerWebSockerServer() {
        return new HtmlRtspPlayerWebSockerServer();
    }

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler(htmlRtspPlayerWebSockerServer(), "/player").setAllowedOrigins("*").addInterceptors(new WebSocketHandshakeInterceptor());
    }

}
