package com.yeejoin.amos.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.entity.MonitorParam;
import com.yeejoin.amos.entity.PageModel;
import com.yeejoin.amos.entity.RtspAddressBean;
import com.yeejoin.amos.entity.Video;
import com.yeejoin.amos.response.CommonResponse;
import com.yeejoin.amos.server.ParamsConfig;
import com.yeejoin.amos.service.PageService;
import com.yeejoin.amos.service.VideoService;
import com.yeejoin.amos.util.CommonResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

@RestController
@RequestMapping(value = "/rtsp")
public class AddressController {

	private final Logger log = LoggerFactory.getLogger(AddressController.class);
	
	@Autowired
	VideoService videoService;

	@Autowired
	private PageService pageService;

	@PostMapping(value = "/address", produces = "application/json;charset=UTF-8")
	public CommonResponse getRtspAddress(@RequestBody List<RtspAddressBean> list) {
		try {
			// URL
			List<String> listUrls = new ArrayList<>();
			for (RtspAddressBean bean : list) {
				// rtsp://admin:zjt123456@172.16.18.21:554/h264/ch1/main/av_stream
				String url = "rtsp://" + bean.getUserName() + ":" + bean.getPwd() + "@" + bean.getIp() + ":"
						+ bean.getPort() + "/" + bean.getVideoFormat() + "/" + bean.getChannel() + "/main/av_stream";
				listUrls.add(url);
			}
			return CommonResponseUtil.success(listUrls);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取地址失败");
		}
	}
	
	/**
	   *  分页查询摄像头列表
	 * @param param
	 * @return
	 */
	@PostMapping(value = "/listVideoByPage", produces = "application/json;charset=UTF-8")
	public CommonResponse getVideos(@RequestBody(required = true) MonitorParam param) {
		try {
			PageModel<Video> findRoadPageList = videoService.findPageList(param);
			return CommonResponseUtil.success(findRoadPageList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取失败");
		}
	}
	
	/**
	   * 获取所有节点列表（树结构）
	 * @return
	 */
	@GetMapping(value = "/list", produces = "application/json;charset=UTF-8")
	public CommonResponse getVideosList(@RequestParam("floor3d") String floor3d) {
		try {
			List<Video> findAll = videoService.findAll(floor3d);
			return CommonResponseUtil.success(findAll);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取失败");
		}
	}

	/**
	 * 获取所有节点列表（树结构）
	 * @return
	 */
	@GetMapping(value = "/monitorVideoTree", produces = "application/json;charset=UTF-8")
	public CommonResponse getVideosTree() {
		try {
			List<Map<String, Object>> resultList = videoService.videoTree();
			return CommonResponseUtil.success(resultList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取失败");
		}
	}

	/**
	 *  分页查询摄像头列表
	 * @param param
	 * @return
	 */
	@PostMapping(value = "/monitorVideoByPage", produces = "application/json;charset=UTF-8")
	public CommonResponse getPageMonitorVideo(@RequestBody(required = true) MonitorParam param){

		List list = pageService.doService(param);
		return CommonResponseUtil.success(list);
	}
}
