package com.yeejoin.amos.controller;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.entity.H5Response;
import com.yeejoin.amos.entity.Video;
import com.yeejoin.amos.response.CommonResponse;
import com.yeejoin.amos.server.ParamsConfig;
import com.yeejoin.amos.server.RemoteServer;
import com.yeejoin.amos.service.VideoService;
import com.yeejoin.amos.util.CommonResponseUtil;

@RestController
@RequestMapping(value = "/video")
public class VideoController {

	private final Logger log = LoggerFactory.getLogger(VideoController.class);
	
	@Autowired
	VideoService videoService;
	
	@Resource(name = "paramsConfig")
	private ParamsConfig paramsConfig;
	
	@Autowired
	RemoteServer server;

	/**
	 * 添加设备
	 * @param list
	 * @return
	 */
	@PostMapping(value = "/addDevice", produces = "application/json;charset=UTF-8")
	public CommonResponse getAddDevice(@RequestBody Video bean) {
		try {
			H5Response addDevice = videoService.addDevice(bean);
			if(addDevice.isbStatus()) {
				log.info("add device success!");
				return CommonResponseUtil.success(bean);
			}else {
				log.error("add device fail!");
				return CommonResponseUtil.failure("add device fail!");
			}
			
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("添加设备失败");
		}
	}
	
	
	
	/**
	   * 获取设备信息
	 * @return
	 */
	@GetMapping(value = "/getDeviceMsg", produces = "application/json;charset=UTF-8")
	public CommonResponse getDeviceMsg(@RequestParam(value ="token") String token) {
		try {
			
			Video device = videoService.getDevice(token);
			if(null!=device) {
				return CommonResponseUtil.success(device);
			}else {
				return CommonResponseUtil.failure("该设备不存在");
			}
			
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取设备信息失败");
		}
	}
	
	
	/**
	 * 删除设备信息
	 * @return
	 */
	@DeleteMapping(value = "/deleteDeviceMsg", produces = "application/json;charset=UTF-8")
	public CommonResponse deleteDevice(@RequestParam(value ="token") String token) {
		try {
			
			H5Response deleteDevice = videoService.deleteDevice(token);
			if(deleteDevice.isbStatus()) {
				log.info("delete device success!");
				return CommonResponseUtil.success(deleteDevice);
			}else {
				log.error("delete device fail!");
				return CommonResponseUtil.failure("设备不存在");
			}
			
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取设备信息失败");
		}
	}
	
	/**
	 * 更新设备楼层和三维信息
	 * @param bean
	 * @return
	 */
	@PutMapping(value = "/updateDevice", produces = "application/json;charset=UTF-8")
	public CommonResponse updateDevice(@RequestBody Video bean) {
		try {
			if(null==bean.getId()) {
				return CommonResponseUtil.failure("设备token不可为空");
			}
			
			videoService.updateDevice(bean);
			return CommonResponseUtil.success();
			
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("更新设备失败");
		}
	}
}
