package com.yeejoin.amos.entity;
/**
 * 用于请求和返回数据使用
 *
 */
public class BaseParam {
	Long id;
	/**
	 * 页码，默认值1
	 */
	protected Integer current = 1;
	/**
	 * 每页记录数
	 */
	private Integer pageSize;
	
	/**
	 * 设备名称
	 */
	private String name;
	
	/**
	 * 是否叶子节点，默认true
	 */
	private Boolean isLeaf = true;
	
	/**
	 * 从第几条记录开始查
	 * @return
	 */
	public Integer getStartPage(){
		if(current!=null && current==0) {
			return 0;
		}
		return (current - 1) * pageSize;
	}
	
	public Integer getCurrent() {
		return current;
	}
	public void setCurrent(Integer current) {
		this.current = current;
	}
	public void setPageNum(Integer current) {
		this.current = current;
	}
	public Integer getPageSize() {
		if(current!=null && current==0) {
			return Integer.MAX_VALUE;
		}
		return pageSize;
	}
	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Boolean getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Boolean isLeaf) {
		this.isLeaf = isLeaf;
	}
	
}
