package com.yeejoin.amos.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "b_monitor_video")
@org.hibernate.annotations.Table(appliesTo = "b_monitor_video", comment = "摄像头信息表")
public class Video implements Serializable {

	private static final long serialVersionUID = 3499756800920010671L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id", nullable = true)
	private Long id;

	@Column(name = "name", columnDefinition = "varchar(255) COMMENT '设备名称'")
	private String name;

	@Column(name = "parent_id", columnDefinition = "varchar(255) COMMENT '父ID'")
	private Long parentId;

	@Column(name = "is_leaf", columnDefinition = "bit COMMENT '是否叶子节点'")
	private Integer isLeaf;

	@Column(name = "ip", columnDefinition = "varchar(255) COMMENT '设备IP'")
	private String ip;

	@Column(name = "rtsp_address", columnDefinition = "varchar(255) COMMENT '视频rtsp地址'")
	private String rtspAddress;

	@Column(name = "url", columnDefinition = "varchar(255) COMMENT '视频访问url'")
	private String url;

	@Column(name = "text", columnDefinition = "varchar(255) COMMENT '备注'")
	private String text;

	@Column(name = "carmera_type", columnDefinition = "varchar(255) COMMENT '设备类型'")
	private String carmeraType;
	
	@Column(name = "position3d", columnDefinition = "varchar(255) COMMENT '三维坐标信息'")
	private String position3d;
	
	@Column(name = "floor3d", columnDefinition = "varchar(255) COMMENT '楼层'")
	private String floor3d;
	
	@Column(name = "is_indoor", columnDefinition = "bit COMMENT '室内室外：1 为室内，0为室外'")
	private Boolean isIndoor;
	
	@Column(name = "status", columnDefinition = "int(10) COMMENT '监控视频状态：【1：正常；0：异常】'")
	private int status;
	
	@Column(name = "token", columnDefinition = "varchar(255) COMMENT '摄像头唯一token'")
	private String token;
	
	@Column(name = "user", columnDefinition = "varchar(255) COMMENT '用户名'")
	private String user;
	
	@Column(name = "password", columnDefinition = "varchar(255) COMMENT '密码'")
	private String password;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Integer getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Integer isLeaf) {
		this.isLeaf = isLeaf;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getRtspAddress() {
		return rtspAddress;
	}

	public void setRtspAddress(String rtspAddress) {
		this.rtspAddress = rtspAddress;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String getCarmeraType() {
		return carmeraType;
	}

	public void setCarmeraType(String carmeraType) {
		this.carmeraType = carmeraType;
	}

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}
	
}
