package com.yeejoin.amos.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
import com.yeejoin.amos.entity.Video;

@Repository
public interface VideoMapper {

	public Integer getCount(@Param("name") String name, @Param("parentId") Long parentId);

	public List<Video> findPageList( @Param("offset")Integer offset,@Param("pageSize") Integer pageSize,@Param("name") String name, @Param("parentId") Long parentId);
	
	/**
	 * 根据楼层查询摄像头
	 * @param floor3d
	 * @return
	 */
	public List<Video> findAll(@Param("floor3d") String floor3d);

	List<Video> selectByParentId();
	
    void insertVideo(Video video);
    
    void deleteVideo(@Param("token") String token);
    
    
    Video selectByToken(@Param("token") String token);
    
    void updateVideo(Video video);
    
}
