package com.yeejoin.amos.response;

import java.io.Serializable;

public class CommonResponse implements Serializable
{
    private static final long serialVersionUID = -8737351878134480646L;
    private String result;
    private Object dataList;
    private String message;
    
    public CommonResponse() {
    }
    
    public CommonResponse(final String result) {
        this.result = result;
    }
    
    public CommonResponse(final Object dataList) {
        this.dataList = dataList;
        this.result = "";
    }
    
    public CommonResponse(final String result, final Object dataList) {
        this.dataList = dataList;
        this.result = result;
    }
    
    public CommonResponse(final String result, final String message) {
        this.result = result;
        this.message = message;
    }
    
    public CommonResponse(final String result, final Object dataList, final String message) {
        this.dataList = dataList;
        this.result = result;
        this.message = message;
    }
    
    public Boolean isSuccess() {
        return "SUCCESS".equals(this.getResult());
    }
    
    public String getResult() {
        return this.result;
    }
    
    public void setResult(final String result) {
        this.result = result;
    }
    
    public String getMessage() {
        return this.message;
    }
    
    public void setMessage(final String message) {
        this.message = message;
    }
    
    public Object getDataList() {
        return this.dataList;
    }
    
    public void setDataList(final Object dataList) {
        this.dataList = dataList;
    }
    
}
