package com.yeejoin.amos.service;

import com.github.pagehelper.PageHelper;
import com.yeejoin.amos.entity.BaseParam;
import com.yeejoin.amos.entity.PageModel;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @Author: xinglei
 * @Description: TODO()
 * @Date: 2019/11/29 14:30
 */
@Service
public class PageService {

    @Autowired
    public SqlSessionTemplate sqlSession;
    private String sqlId;
    private String oraderByField;
    private String oraderByType;

    public PageService() {
    }

    public void setOraderByField(String oraderByField) {
        this.oraderByField = oraderByField;
    }

    public void setOraderByType(String oraderByType) {
        this.oraderByType = oraderByType;
    }

    public void setSqlId(String sqlId) {
        this.sqlId = sqlId;
    }

    public List<Map<String, Object>> doService(BaseParam param) {
        PageModel pageModel = new PageModel();

        if (oraderByField == null || oraderByField.toString().trim().equals("") || oraderByType == null || !oraderByType.toString().equalsIgnoreCase("desc") && !oraderByType.toString().equalsIgnoreCase("asc")) {
            if (this.oraderByField == null || this.oraderByField.trim().equals("") || this.oraderByType == null || !this.oraderByType.equalsIgnoreCase("desc") && !this.oraderByType.equalsIgnoreCase("asc")) {
                PageHelper.startPage(param.getCurrent(), param.getPageSize());
            } else {
                PageHelper.startPage(param.getCurrent(), param.getPageSize(), Boolean.parseBoolean(this.oraderByField + " " + this.oraderByType));
            }
        } else {
            PageHelper.startPage(param.getCurrent(), param.getPageSize(), Boolean.parseBoolean(oraderByField + " " + oraderByType));
        }

        List<Map<String, Object>> list = this.sqlSession.selectList(this.sqlId, param);

        return list;
    }
}
