package com.yeejoin.amos.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.entity.DeviceBean;
import com.yeejoin.amos.entity.H5Response;
import com.yeejoin.amos.entity.MonitorParam;
import com.yeejoin.amos.entity.PageModel;
import com.yeejoin.amos.entity.Video;

public interface VideoService {

	public PageModel<Video> findPageList(MonitorParam param);
	
	List<Video> findAll(String floor3d);

	List<Map<String, Object>> videoTree();
	
	/**
	 * 添加设备
	 * @return
	 */
	H5Response addDevice(Video bean);
	
	
	/**
	 * 删除设备
	 * @return
	 */
	H5Response deleteDevice(String token);
	
	
	/**
	 * 查询设备信息
	 * @return
	 */
	Video getDevice(String token);
	
	/**
	 * 更新设备
	 * @param bean
	 */
	public void updateDevice(Video bean);
}
