package com.yeejoin.amos.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.dao.IVideoDao;
import com.yeejoin.amos.util.TreeDto;
import com.yeejoin.amos.util.TreeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.entity.H5Response;
import com.yeejoin.amos.entity.MonitorParam;
import com.yeejoin.amos.entity.PageModel;
import com.yeejoin.amos.entity.Video;
import com.yeejoin.amos.mapper.VideoMapper;
import com.yeejoin.amos.server.RemoteServer;
import org.springframework.util.ObjectUtils;

@Transactional
@Service
public class VideoServiceImpl implements VideoService {

    @Autowired
    VideoMapper mapper;

    @Autowired
    RemoteServer server;

    @Autowired
    IVideoDao videoDao;

    @Override
    public PageModel<Video> findPageList(MonitorParam param) {
        List<Video> findPageList = mapper.findPageList(param.getStartPage(), param.getPageSize(), param.getName(),
                param.getParentId());
        Integer count = mapper.getCount(param.getName(), param.getParentId());
        PageModel<Video> pm = new PageModel<>(count, param.getCurrent(), param.getPageSize(), findPageList);
        return pm;
    }

    @Override
    public List<Video> findAll(String floor3d) {
        List<Video> findAll = mapper.findAll(floor3d);
        return findAll;
    }

    @Override
    public List<Map<String, Object>> videoTree() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<Video> videos = videoDao.findAll();
        List<TreeDto> rootNode = getRootNode();
        List<TreeDto> treeDtos = buildNodeTree(rootNode, videos);
        resultList = (List<Map<String, Object>>)(JSON.toJSON(treeDtos));
        List<Map<String, Object>> list = new ArrayList<>();
        resultList.forEach(
                result -> {
                    Object children = result.get("children");
                    if (!ObjectUtils.isEmpty(children)) {
                        list.add(result);
                    }
                }
        );
        return resultList;
    }

    @Override
    public H5Response addDevice(Video bean) {
        H5Response addDevice = server.addDevice(bean);
        mapper.insertVideo(bean);
        return addDevice;
    }

    @Override
    public H5Response deleteDevice(String token) {
        H5Response addDevice = server.deleteDevice(token);
        mapper.deleteVideo(token);
        return addDevice;
    }

    @Override
    public Video getDevice(String token) {
        Video selectByToken = mapper.selectByToken(token);
        return selectByToken;
    }

    @Override
    public void updateDevice(Video bean) {
        mapper.updateVideo(bean);
    }

    private List<TreeDto> buildNodeTree(List<TreeDto> rootNode, List<Video> videos) {
        List<TreeDto> list = new ArrayList<>();
        videos.forEach(video -> {
            TreeDto node = new TreeDto();
            node.setId(video.getId().toString());
            node.setIsLeaf(video.getIsLeaf().toString());
            node.setName(video.getName());
            node.setParentId(ObjectUtils.isEmpty(video.getParentId()) ? "" : video.getParentId().toString());
            node.setUrl(video.getUrl());
            node.setToken(video.getToken());
            node.setUser(video.getUser());
            node.setPassword(video.getPassword());
            list.add(node);
        });
        return TreeUtil.findTree(rootNode, list);
    }

    private List<TreeDto> getRootNode() {
        Map<String, Object> map = new HashMap<>();

        List<Video> videos = mapper.selectByParentId();
        ArrayList<TreeDto> rootNode = new ArrayList<>();
        videos.forEach(
                video -> {
                    TreeDto treeDto = new TreeDto();
                    treeDto.setName(video.getName());
                    treeDto.setId(video.getId().toString());
                    treeDto.setIsLeaf(video.getIsLeaf().toString());
                    treeDto.setParentId(ObjectUtils.isEmpty(video.getParentId()) ? "" : video.getParentId().toString());
                    treeDto.setUrl(video.getUrl());
                    treeDto.setToken(video.getToken());
                    treeDto.setUser(video.getUser());
                    treeDto.setPassword(video.getPassword());
                    rootNode.add(treeDto);
                }
        );
        return rootNode;
    }
}
