"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.currentUser = exports.getAssideStatus = exports.changeAssideStatus = void 0;
var _amosTool = require("amos-tool"),
  _consts = _interopRequireDefault(require("amos-processor/lib/config/consts"));

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}
var lsTool = _amosTool.Store.lsTool,
  userConfigs = {
    leftAsideOpenFlag: "leftAsideOpenFlag",
    rightAsideOpenFlag: "rightAsideOpenFlag",
    changeLanguageFlag: "changeLanguageFlag",
    skinName: "skinName",
    themeColor: "themeColor"
  },
  changeAssideStatus = function(e, s) {
    s = s ? 1 : 0;
    "right" === e ? lsTool.write(userConfigs.rightAsideOpenFlag, s) : "left" === e && lsTool.write(userConfigs.leftAsideOpenFlag, s)
  };
exports.changeAssideStatus = changeAssideStatus;
var getAssideStatus = function() {
  var e = lsTool.read(userConfigs.leftAsideOpenFlag),
    s = lsTool.read(userConfigs.rightAsideOpenFlag);
  return {
    left: transUndefinedToDefault(e, !1),
    right: transUndefinedToDefault(s, !1)
  }
};
exports.getAssideStatus = getAssideStatus;
var transUndefinedToDefault = function(e, s) {
    s = 1 < arguments.length && void 0 !== s ? s : "";
    return 0 !== e && "0" !== e && (1 === e || "1" === e || (_amosTool.utils.isEmpty(e) ? s : e))
  },
  currentUser = function() {
    var e = JSON.parse(lsTool.read(_consts.default.company));
    return {
      api_key: _amosTool.Store.getCookieByName(_consts.default.api_key),
      token: lsTool.read(_consts.default.token),
      userId: lsTool.read(_consts.default.userId),
      userName: lsTool.read(_consts.default.userName),
      nickName: lsTool.read(_consts.default.nickName),
      company: e
    }
  };
exports.currentUser = currentUser;
