"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.default = void 0;
var _react = _interopRequireWildcard(require("react")),
  _propTypes = _interopRequireDefault(require("prop-types")),
  _amosAntd = require("amos-antd"),
  _amosFramework = require("amos-framework"),
  _processor = require("./../../common/utils/processor"),
  _validate = require("./../../common/utils/validate");

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}

function _getRequireWildcardCache() {
  if ("function" != typeof WeakMap) return null;
  var e = new WeakMap;
  return _getRequireWildcardCache = function() {
    return e
  }, e
}

function _interopRequireWildcard(e) {
  if (e && e.__esModule) return e;
  if (null === e || "object" !== _typeof(e) && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache();
  if (t && t.has(e)) return t.get(e);
  var a, r, n = {},
    o = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (a in e) Object.prototype.hasOwnProperty.call(e, a) && ((r = o ? Object.getOwnPropertyDescriptor(e, a) : null) && (r.get || r.set) ? Object.defineProperty(n, a, r) : n[a] = e[a]);
  return n.default = e, t && t.set(e, n), n
}

function _typeof(e) {
  return (_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
    return typeof e
  } : function(e) {
    return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
  })(e)
}

function _extends() {
  return (_extends = Object.assign || function(e) {
    for (var t = 1; t < arguments.length; t++) {
      var a, r = arguments[t];
      for (a in r) Object.prototype.hasOwnProperty.call(r, a) && (e[a] = r[a])
    }
    return e
  }).apply(this, arguments)
}

function _classCallCheck(e, t) {
  if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
}

function _defineProperties(e, t) {
  for (var a = 0; a < t.length; a++) {
    var r = t[a];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(e, r.key, r)
  }
}

function _createClass(e, t, a) {
  return t && _defineProperties(e.prototype, t), a && _defineProperties(e, a), e
}

function _inherits(e, t) {
  if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function");
  e.prototype = Object.create(t && t.prototype, {
    constructor: {
      value: e,
      writable: !0,
      configurable: !0
    }
  }), t && _setPrototypeOf(e, t)
}

function _setPrototypeOf(e, t) {
  return (_setPrototypeOf = Object.setPrototypeOf || function(e, t) {
    return e.__proto__ = t, e
  })(e, t)
}

function _createSuper(a) {
  var r = _isNativeReflectConstruct();
  return function() {
    var e, t = _getPrototypeOf(a);
    return _possibleConstructorReturn(this, r ? (e = _getPrototypeOf(this).constructor, Reflect.construct(t, arguments, e)) : t.apply(this, arguments))
  }
}

function _possibleConstructorReturn(e, t) {
  return !t || "object" !== _typeof(t) && "function" != typeof t ? _assertThisInitialized(e) : t
}

function _assertThisInitialized(e) {
  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return e
}

function _isNativeReflectConstruct() {
  if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
  if (Reflect.construct.sham) return !1;
  if ("function" == typeof Proxy) return !0;
  try {
    return Date.prototype.toString.call(Reflect.construct(Date, [], function() {})), !0
  } catch (e) {
    return !1
  }
}

function _getPrototypeOf(e) {
  return (_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(e) {
    return e.__proto__ || Object.getPrototypeOf(e)
  })(e)
}

function _defineProperty(e, t, a) {
  return t in e ? Object.defineProperty(e, t, {
    value: a,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[t] = a, e
}
var FormItem = _amosAntd.Form.Item,
  Option = _amosFramework.Select.Option,
  nameText = "单位名称",
  superiorText = "上级单位",
  levelText = "单位级别",
  describesText = "单位描述",
  tipErrorText = "上级名称不能为空！",
  nameErrorText = "单位名称不能为空！",
  levelErrorText = "单位级别不能为空！",
  dataToTree = function t(e) {
    (0 < arguments.length && void 0 !== e ? e : []).map(function(e) {
      e.label = e.text, e.key = e.id, e.value = e.id, e.children && t(e.children)
    })
  },
  CompanyAddEdit = function() {
    _inherits(r, _react.Component);
    var a = _createSuper(r);

    function r(e) {
      var t;
      return _classCallCheck(this, r), _defineProperty(_assertThisInitialized(t = a.call(this, e)), "getCompanyLevels", function() {
        t.props.companyLevelsAction()
      }), _defineProperty(_assertThisInitialized(t), "companyLevelChange", function(e) {
        t.setState({
          level: e
        })
      }), _defineProperty(_assertThisInitialized(t), "checkMobile", function(e, t, a) {
        t && !_processor.AmosValidate.isPhone(t) ? a("请输入正确的电话号码格式！") : a()
      }), _defineProperty(_assertThisInitialized(t), "checkEmail", function(e, t, a) {
        t && (!_processor.AmosValidate.isEmail(t) || 25 < t.length) ? a("请输入正确的邮箱格式！") : a()
      }), t.state = {
        level: e.company.companyLevel,
        fireStationLevels: []
      }, t
    }
    return _createClass(r, [{
      key: "componentDidMount",
      value: function() {
        this.getCompanyLevels()
      }
    }, {
      key: "componentWillReceiveProps",
      value: function(e) {
        this.setState({
          level: e.company.companyLevel
        })
      }
    }, {
      key: "render",
      value: function() {
        var e = this.props,
          t = e.company,
          a = e.parentform,
          r = e.submit,
          n = e.superiorUnitData,
          o = (e.companyLevels, t.companyName),
          l = (t.companyLevel, t.description),
          i = t.parentId,
          s = t.longitude,
          c = (t.siteId, t.latitude),
          u = t.contact,
          d = t.address,
          e = t.telephone,
          a = (t.email, a.getFieldProps),
          o = a("companyName", {
            initialValue: o,
            rules: [{
              required: !0,
              message: nameErrorText
            }, {
              validator: (0, _validate.textLengthValidate)(255, 2)
            }]
          }),
          i = a("parentId", {
            initialValue: i ? "".concat(i) : null,
            rules: [{
              required: "省总队" !== this.state.level,
              message: tipErrorText
            }]
          }),
          l = (a("companyLevel", {
            initialValue: null,
            rules: []
          }), a("description", {
            initialValue: l,
            rules: [{
              validator: (0, _validate.textLengthValidate)(255)
            }]
          })),
          s = a("longitude", {
            initialValue: s,
            rules: [{
              validator: (0, _validate.textValueValidate)(180, -180)
            }]
          }),
          c = a("latitude", {
            initialValue: c,
            rules: [{
              validator: (0, _validate.textValueValidate)(90, -90)
            }]
          }),
          u = a("contact", {
            initialValue: u,
            rules: [{
              validator: (0, _validate.textLengthValidate)(10)
            }]
          }),
          d = a("address", {
            initialValue: d,
            rules: [{
              validator: (0, _validate.textLengthValidate)(50)
            }]
          }),
          e = a("telephone", {
            initialValue: e,
            rules: [{
              validator: this.checkMobile
            }]
          }),
          a = (a("email", {
            initialValue: null
          }), {
            labelCol: {
              span: 7
            },
            wrapperCol: {
              span: 16
            }
          });
        return _react.default.createElement("div", {
          className: "company-add-edit amos-grid-from"
        }, _react.default.createElement(_amosAntd.Form, {
          inline: !0,
          onSubmit: r
        }, _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: nameText
        }, a), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, o, {
          style: {
            width: 240
          }
        })))), _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: superiorText
        }, a), _react.default.createElement(_amosAntd.TreeSelect, _extends({
          instanceId: "patent-company",
          showSearch: !0,
          className: "amos-grid-form-select",
          style: {
            width: 240
          },
          dropdownStyle: {
            maxHeight: 250,
            overflow: "auto"
          },
          treeData: n,
          placeholder: "上级单位",
          treeDefaultExpandAll: !0,
          treeNodeFilterProp: "title",
          notFoundContent: "无匹配结果"
        }, i))))), _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: "经度"
        }, a), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, s, {
          style: {
            width: 240
          }
        })))), _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: "纬度"
        }, a), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, c, {
          style: {
            width: 240
          }
        }))))), _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: "联系人"
        }, a), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, u, {
          style: {
            width: 240
          }
        })))), _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: "地址"
        }, a), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, d, {
          style: {
            width: 240
          }
        }))))), _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: "电话"
        }, a), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, e, {
          style: {
            width: 240
          }
        }))))), _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: describesText
        }, a), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-textarea",
          type: "textarea",
          rows: 3,
          style: {
            width: 240
          }
        }, l)))))))
      }
    }]), r
  }();
CompanyAddEdit.displayName = "CompanyAddEdit", CompanyAddEdit.propTypes = {
  company: _propTypes.default.object,
  superiorUnitData: _propTypes.default.array,
  superiorUnitEditData: _propTypes.default.array,
  submit: _propTypes.default.func,
  cancel: _propTypes.default.func,
  parentform: _propTypes.default.any,
  companyLevels: _propTypes.default.array,
  companyLevelsAction: _propTypes.default.func
}, CompanyAddEdit.defaultProps = {
  companyLevels: [],
  company: {
    companyName: "",
    companyLevel: "",
    description: ""
  }
};
var _default = CompanyAddEdit;
exports.default = CompanyAddEdit, module.exports = exports.default;
