"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.default = void 0;
var _react = _interopRequireWildcard(require("react")),
  _propTypes = _interopRequireDefault(require("prop-types")),
  _amosAntd = require("amos-antd"),
  _rayEventpool = require("ray-eventpool"),
  _amosFramework = require("amos-framework"),
  _dt2react = _interopRequireDefault(require("dt2react")),
  _ActionConf = require("./../common/ActionConf"),
  _AmosGridTable = _interopRequireDefault(require("./../../common/tableComponent/table/AmosGridTable")),
  _DeviceEnum = require("./../../deviceManage/common/DeviceEnum"),
  _DeviceLang = require("./../../deviceManage/common/DeviceLang");

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}

function _getRequireWildcardCache() {
  if ("function" != typeof WeakMap) return null;
  var e = new WeakMap;
  return _getRequireWildcardCache = function() {
    return e
  }, e
}

function _interopRequireWildcard(e) {
  if (e && e.__esModule) return e;
  if (null === e || "object" !== _typeof(e) && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache();
  if (t && t.has(e)) return t.get(e);
  var n, r, i = {},
    o = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (n in e) Object.prototype.hasOwnProperty.call(e, n) && ((r = o ? Object.getOwnPropertyDescriptor(e, n) : null) && (r.get || r.set) ? Object.defineProperty(i, n, r) : i[n] = e[n]);
  return i.default = e, t && t.set(e, i), i
}

function _typeof(e) {
  return (_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
    return typeof e
  } : function(e) {
    return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
  })(e)
}

function _objectDestructuringEmpty(e) {
  if (null == e) throw new TypeError("Cannot destructure undefined")
}

function _classCallCheck(e, t) {
  if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
}

function _defineProperties(e, t) {
  for (var n = 0; n < t.length; n++) {
    var r = t[n];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(e, r.key, r)
  }
}

function _createClass(e, t, n) {
  return t && _defineProperties(e.prototype, t), n && _defineProperties(e, n), e
}

function _inherits(e, t) {
  if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function");
  e.prototype = Object.create(t && t.prototype, {
    constructor: {
      value: e,
      writable: !0,
      configurable: !0
    }
  }), t && _setPrototypeOf(e, t)
}

function _setPrototypeOf(e, t) {
  return (_setPrototypeOf = Object.setPrototypeOf || function(e, t) {
    return e.__proto__ = t, e
  })(e, t)
}

function _createSuper(n) {
  var r = _isNativeReflectConstruct();
  return function() {
    var e, t = _getPrototypeOf(n);
    return _possibleConstructorReturn(this, r ? (e = _getPrototypeOf(this).constructor, Reflect.construct(t, arguments, e)) : t.apply(this, arguments))
  }
}

function _possibleConstructorReturn(e, t) {
  return !t || "object" !== _typeof(t) && "function" != typeof t ? _assertThisInitialized(e) : t
}

function _assertThisInitialized(e) {
  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return e
}

function _isNativeReflectConstruct() {
  if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
  if (Reflect.construct.sham) return !1;
  if ("function" == typeof Proxy) return !0;
  try {
    return Date.prototype.toString.call(Reflect.construct(Date, [], function() {})), !0
  } catch (e) {
    return !1
  }
}

function _getPrototypeOf(e) {
  return (_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(e) {
    return e.__proto__ || Object.getPrototypeOf(e)
  })(e)
}

function _defineProperty(e, t, n) {
  return t in e ? Object.defineProperty(e, t, {
    value: n,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[t] = n, e
}
var deviceColumns = function(n, r, i) {
    return [{
      title: "设备名称",
      dataIndex: "name",
      key: "name",
      width: "16%"
    }, {
      title: "设备类型",
      dataIndex: "tmplName",
      key: "tmplName",
      width: "12%",
      render: function(e, t) {
        var n = "tree-td-children";
        return t.children && 0 === t.children.length && (n = "tree-td-children-empty"), _react.default.createElement("div", {
          className: n
        }, r.name)
      }
    }, {
      title: "设备类别",
      dataIndex: "type",
      key: "type",
      width: "12%",
      render: function() {
        return (0, _DeviceLang.stringUtil)(_DeviceEnum.deviceCategoryEnum, r.type)
      }
    }, {
      title: "所属行业",
      dataIndex: "industryId",
      key: "industryId",
      width: "10%",
      render: function() {
        return r.equipTemplateIndustry.name
      }
    }, {
      title: "设备型号",
      dataIndex: "model",
      key: "model",
      width: "12%",
      render: function() {
        return r.model
      }
    }, {
      title: "设备描述",
      dataIndex: "descr",
      key: "descr",
      width: "16%"
    }, , {
      title: "所属视图",
      dataIndex: "nodeName",
      key: "nodeName",
      width: "12%"
    }, {
      title: "操作",
      key: "action",
      width: "16%",
      render: function(e, t) {
        return _react.default.createElement("span", null, _react.default.createElement("label", {
          className: "view-detail",
          onClick: function() {
            return n.updateMainView({
              flag: "5",
              device: r,
              resourceFlag: "3",
              equipment: t,
              pageConfig: i
            })
          }
        }, "详情"), _react.default.createElement("label", {
          className: "edit-device",
          onClick: function() {
            return n.updateMainView({
              flag: "4",
              device: r,
              resourceFlag: "3",
              equipment: t,
              pageConfig: i
            })
          }
        }, "编辑"), _react.default.createElement("label", {
          className: "delete-device",
          onClick: function() {
            return n.deleteDevice(t.id)
          }
        }, "删除"))
      }
    }]
  },
  offsetHeight = 110,
  defaultHeight = 450,
  DeviceListPanelContent = function() {
    _inherits(n, _react.Component);
    var t = _createSuper(n);

    function n(e) {
      var r;
      return _classCallCheck(this, n), _defineProperty(_assertThisInitialized(r = t.call(this, e)), "getSelectedRows", function(e, t) {
        r.setState({
          selectedRows: e,
          selectedRowKeys: t
        })
      }), _defineProperty(_assertThisInitialized(r), "reload", function(e) {
        r.setState({
          reload: function() {
            e(), r.setState({
              selectedRows: [],
              selectedRowKeys: []
            })
          }
        }, e())
      }), _defineProperty(_assertThisInitialized(r), "deleteDevice", function(t) {
        _amosAntd.Modal.confirm({
          content: "确定要删除吗？",
          onCancel: function() {},
          onOk: function() {
            var e = [t];
            r.props.deleteDeviceById(e)
          }
        })
      }), _defineProperty(_assertThisInitialized(r), "deleteMultiDevice", function(e) {
        _amosAntd.Modal.confirm({
          content: "确定要删除吗？",
          onCancel: function() {},
          onOk: function() {
            r.props.deleteDeviceById(e)
          }
        })
      }), _defineProperty(_assertThisInitialized(r), "getRowClassName", function(e, t) {
        var n = r.highlight;
        return n && e.id === n ? "highlight-row" : "normal-row"
      }), _defineProperty(_assertThisInitialized(r), "setPageConfig", function(e) {
        var t = e.pageSize,
          e = e.current;
        void 0 !== t && (r.pageConfig.pageSize = t), void 0 !== e && (r.pageConfig.current = e)
      }), _defineProperty(_assertThisInitialized(r), "getPanelHeight", function() {
        var e = r.alarmTablePanel,
          e = _dt2react.default.getOffset(e) || {};
        return e.height - offsetHeight
      }), r.pageConfig = {
        current: e.outterPageConfig ? e.outterPageConfig.current : 1,
        pageSize: e.outterPageConfig ? e.outterPageConfig.pageSize : 10
      }, r.state = {
        selectedRows: [],
        selectedRowKeys: [],
        reload: function() {}
      }, r
    }
    return _createClass(n, [{
      key: "componentWillMount",
      value: function() {}
    }, {
      key: "componentDidMount",
      value: function() {
        var n = this;
        this.batchDelete = _rayEventpool.PubSub.subscribe(_ActionConf.EQUIPMENT_BATCH_DELETE_TOPIC.equipmentBatchDelete, function(e, t) {
          _objectDestructuringEmpty(t);
          t = n.state.selectedRowKeys;
          0 === t.length ? _amosFramework.message.danger("请选择要删除的设备") : n.deleteMultiDevice(t)
        })
      }
    }, {
      key: "componentWillReceiveProps",
      value: function(e) {
        var t, n = e.equipment;
        void 0 !== n && (e = (t = this.state).selectedRows, t = t.selectedRowKeys, e.push(n), t.push(n.id), this.highlight = n.id)
      }
    }, {
      key: "componentWillUnmount",
      value: function() {
        _rayEventpool.PubSub.unsubscribe(this.batchDelete)
      }
    }, {
      key: "render",
      value: function() {
        var t = this,
          e = this.props,
          n = e.equipmentList,
          r = e.fetchData,
          i = e.device,
          o = e.count,
          a = e.updateMainView,
          c = this.state.reload,
          u = this.pageConfig,
          e = this.pageConfig,
          a = {
            deleteDevice: this.deleteDevice,
            reload: c,
            updateMainView: a
          };
        return _react.default.createElement("div", {
          className: "device-list-content",
          ref: function(e) {
            return t.alarmTablePanel = e
          }
        }, _react.default.createElement(_AmosGridTable.default, {
          columns: deviceColumns(a, i, e),
          callBack: this.reload,
          dataList: n,
          totals: o,
          getTableDataAction: r,
          getSelectedRows: this.getSelectedRows,
          rowClassName: this.getRowClassName,
          setPageConfig: this.setPageConfig,
          defaultPageConfig: u,
          getPanelHeight: this.getPanelHeight
        }))
      }
    }]), n
  }();
DeviceListPanelContent.displayName = "DeviceListPanelContent", DeviceListPanelContent.propTypes = {
  equipmentList: _propTypes.default.array,
  fetchData: _propTypes.default.func,
  device: _propTypes.default.object,
  count: _propTypes.default.number,
  updateMainView: _propTypes.default.func,
  deleteDeviceById: _propTypes.default.func,
  equipment: _propTypes.default.object,
  outterPageConfig: _propTypes.default.object
};
var _default = DeviceListPanelContent;
exports.default = DeviceListPanelContent, module.exports = exports.default;
