"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.default = void 0;
var _react = _interopRequireWildcard(require("react")),
  _propTypes = _interopRequireDefault(require("prop-types")),
  _amosViz = require("amos-viz"),
  _rayValidate = require("ray-validate"),
  _DateUtil = require("./../common/date/DateUtil");

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}

function _getRequireWildcardCache() {
  if ("function" != typeof WeakMap) return null;
  var e = new WeakMap;
  return _getRequireWildcardCache = function() {
    return e
  }, e
}

function _interopRequireWildcard(e) {
  if (e && e.__esModule) return e;
  if (null === e || "object" !== _typeof(e) && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache();
  if (t && t.has(e)) return t.get(e);
  var r, o, n = {},
    i = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (r in e) Object.prototype.hasOwnProperty.call(e, r) && ((o = i ? Object.getOwnPropertyDescriptor(e, r) : null) && (o.get || o.set) ? Object.defineProperty(n, r, o) : n[r] = e[r]);
  return n.default = e, t && t.set(e, n), n
}

function _typeof(e) {
  return (_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
    return typeof e
  } : function(e) {
    return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
  })(e)
}

function _classCallCheck(e, t) {
  if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
}

function _defineProperties(e, t) {
  for (var r = 0; r < t.length; r++) {
    var o = t[r];
    o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, o.key, o)
  }
}

function _createClass(e, t, r) {
  return t && _defineProperties(e.prototype, t), r && _defineProperties(e, r), e
}

function _inherits(e, t) {
  if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function");
  e.prototype = Object.create(t && t.prototype, {
    constructor: {
      value: e,
      writable: !0,
      configurable: !0
    }
  }), t && _setPrototypeOf(e, t)
}

function _setPrototypeOf(e, t) {
  return (_setPrototypeOf = Object.setPrototypeOf || function(e, t) {
    return e.__proto__ = t, e
  })(e, t)
}

function _createSuper(r) {
  var o = _isNativeReflectConstruct();
  return function() {
    var e, t = _getPrototypeOf(r);
    return _possibleConstructorReturn(this, o ? (e = _getPrototypeOf(this).constructor, Reflect.construct(t, arguments, e)) : t.apply(this, arguments))
  }
}

function _possibleConstructorReturn(e, t) {
  return !t || "object" !== _typeof(t) && "function" != typeof t ? _assertThisInitialized(e) : t
}

function _assertThisInitialized(e) {
  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return e
}

function _isNativeReflectConstruct() {
  if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
  if (Reflect.construct.sham) return !1;
  if ("function" == typeof Proxy) return !0;
  try {
    return Date.prototype.toString.call(Reflect.construct(Date, [], function() {})), !0
  } catch (e) {
    return !1
  }
}

function _getPrototypeOf(e) {
  return (_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(e) {
    return e.__proto__ || Object.getPrototypeOf(e)
  })(e)
}
var setToolTip = function(e, r) {
    var o = (0, _DateUtil.dateToNoYS)(e[0].data[0]),
      o = "".concat(o, "<br/>");
    return e.map(function(e) {
      var t = e.seriesName,
        e = e.data[1];
      o = "".concat(o, " ").concat('<img src="/src/assets/iot/topo/dot/blue.png" alt>', " ").concat(t, " ").concat(e).concat(r, "<br/>")
    }), o
  },
  dataConversion = function(t, e) {
    var r = [];
    return e.map(function(e) {
      r.push({
        name: e.name,
        type: "line",
        symbol: e.icon,
        symbolSize: 6,
        itemStyle: {
          normal: {
            color: e.color
          }
        },
        lineStyle: {
          color: e.color
        },
        areaStyle: {
          normal: {
            color: "#E7F3FF"
          }
        },
        smooth: !0,
        data: getData(t, e.valueVarName)
      })
    }), r
  },
  getData = function(e, t) {
    return (e[t] || []).map(function(e) {
      if ((0, _rayValidate.isNum)(e.value)) return [e.exeTime, e.value.toFixed(2)]
    })
  },
  HistoryChartView = function() {
    _inherits(r, _react.Component);
    var t = _createSuper(r);

    function r(e) {
      return _classCallCheck(this, r), (e = t.call(this, e)).chartOptions = e.chartOptions.bind(_assertThisInitialized(e)), e
    }
    return _createClass(r, [{
      key: "chartOptions",
      value: function() {
        var e = this.props,
          t = e.unit,
          r = (e.interval, e.min),
          o = e.max,
          n = e.data,
          i = e.legend,
          a = e.axisLabelFormatter;
        return {
          tooltip: {
            trigger: "axis",
            backgroundColor: "#345FA6",
            formatter: function(e) {
              return setToolTip(e, t)
            }
          },
          legend: {
            itemWidth: 11,
            itemHeight: 11,
            data: i,
            bottom: 0
          },
          grid: {
            left: "3%",
            right: "4%",
            top: "13%",
            bottom: "10%",
            containLabel: !0
          },
          xAxis: [{
            type: "value",
            nameTextStyle: {
              color: "#222",
              fontSize: 15
            },
            nameGap: 20,
            splitLine: {
              show: !1
            },
            axisLine: {
              show: !0,
              lineStyle: {
                color: "#BBB"
              }
            },
            splitNumber: 8,
            min: r,
            max: o,
            axisLabel: {
              textStyle: {
                color: "#222",
                fontSize: 13
              },
              formatter: function(e) {
                return a(e)
              }
            }
          }],
          yAxis: {
            name: "单位：".concat(t = t || ""),
            nameLocation: "middle",
            nameGap: 40,
            type: "value",
            splitLine: {
              lineStyle: {
                type: "dotted"
              }
            },
            axisLine: {
              show: !1
            },
            axisTick: {
              show: !1
            }
          },
          series: dataConversion(n, i)
        }
      }
    }, {
      key: "render",
      value: function() {
        var e = this.chartOptions();
        return _react.default.createElement("div", {
          className: "three-phase-view"
        }, _react.default.createElement(_amosViz.LineCharts, {
          lineOps: e,
          shouldDispose: this.props.shouldDispose,
          chartStyle: this.props.chartStyle
        }))
      }
    }]), r
  }();
HistoryChartView.displayName = "HistoryChartView", HistoryChartView.propTypes = {
  unit: _propTypes.default.string,
  interval: _propTypes.default.number,
  min: _propTypes.default.number,
  max: _propTypes.default.number,
  axisLabelFormatter: _propTypes.default.func,
  data: _propTypes.default.object,
  legend: _propTypes.default.array,
  chartStyle: _propTypes.default.object,
  shouldDispose: _propTypes.default.bool
}, HistoryChartView.defaultProps = {
  data: {},
  legend: [],
  chartStyle: {
    width: "100%",
    height: "20rem"
  }
};
var _default = HistoryChartView;
exports.default = HistoryChartView, module.exports = exports.default;
