"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.default = getComponent;
var _amosJsplumb = require("amos-jsplumb"),
  _Device = _interopRequireDefault(require("./datanode/Device")),
  _CurrentUser = _interopRequireDefault(require("./datanode/CurrentUser")),
  _SubUser = _interopRequireDefault(require("./datanode/SubUser")),
  _Task = _interopRequireDefault(require("./datanode/Task")),
  _View = _interopRequireDefault(require("./datanode/View")),
  _AlarmAll = _interopRequireDefault(require("./alarmnode/AlarmAll")),
  _AlarmQuota = _interopRequireDefault(require("./alarmnode/AlarmQuota")),
  _AlarmCollect = _interopRequireDefault(require("./alarmnode/AlarmCollect")),
  _AlarmDeviceOffline = _interopRequireDefault(require("./alarmnode/AlarmDeviceOffline")),
  _OutputEmail = _interopRequireDefault(require("./output/OutputEmail")),
  _OutputMqtt = _interopRequireDefault(require("./output/OutputMqtt")),
  _OutputTcp = _interopRequireDefault(require("./output/OutputTcp"));

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}
var DefaultNode = _amosJsplumb.PlumbEleNode.DefaultNode,
  typeToComponentMap = {
    custom: DefaultNode,
    datanodeDevice: _Device.default,
    datanodeCurrentUser: _CurrentUser.default,
    datanodeSubUser: _SubUser.default,
    datanodeTask: _Task.default,
    datanodeView: _View.default,
    alarmAll: _AlarmAll.default,
    alarmQuota: _AlarmQuota.default,
    alarmCollect: _AlarmCollect.default,
    alarmDeviceOffline: _AlarmDeviceOffline.default,
    outputEmail: _OutputEmail.default,
    outputMqtt: _OutputMqtt.default,
    outputTcp: _OutputTcp.default
  };

function getComponent(e) {
  return typeToComponentMap[e] || DefaultNode
}
module.exports = exports.default;
