"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.typeValue = exports.TREE_FETCH_TOPIC = exports.ELE_UPDATE_TOPIC = exports.transferDropData = exports.isStatusDragLink = exports.isDragLink = exports.isDragEle = exports.completeItemTypeIcon = exports.completeCatalogIcon = exports.eleCatalogIconPrefix = exports.catalogPool = exports.stagePosition = exports.isFlowActionEle = exports.isTriggerEle = exports.eleTypeTopic = exports.locale = exports.ELE_CATALOG_TOPIC = exports.ELE_ENTRY_TOPIC = exports.ELE_DEL_TOPIC = exports.ELE_ADD_TOPIC = exports.eleType = exports.statusCatalog = exports.catalogOperatorIcon = exports.linkList = exports.nodelList = exports.stageIconPath = exports.modelMapping = void 0;
var _amosTool = require("amos-tool"),
  modelMapping = {
    flowAction: "flowAction",
    trigger: "trigger",
    status: "status",
    object: "object",
    note: "note"
  };
exports.modelMapping = modelMapping;
var stageIconPath = "/src/assets/iot/rule/{iconName}.png";
exports.stageIconPath = stageIconPath;
var _nodelList = [{
    key: "datanode",
    icon: "ele-item-datanode",
    text: "数据源",
    children: [{
      key: "datanode-device",
      text: "设备",
      type: "datanodeDevice"
    }, {
      key: "datanode-current-user",
      text: "当前用户",
      type: "datanodeCurrentUser"
    }, {
      key: "datanode-sub-user",
      text: "子用户",
      type: "datanodeSubUser"
    }]
  }, {
    key: "alarm",
    icon: "ele-item-alarm",
    text: "告警节点",
    children: [{
      key: "alarm-all",
      text: "全部告警",
      type: "alarmAll"
    }, {
      key: "alarm-quota",
      text: "指标越界告警",
      type: "alarmQuota"
    }, {
      key: "alarm-collect",
      text: "采集异常告警",
      type: "alarmCollect"
    }, {
      key: "alarm-device-offline",
      text: "设备掉线告警",
      type: "alarmDeviceOffline"
    }]
  }, {
    key: "output",
    icon: "ele-item-output",
    text: "输出节点",
    children: [{
      key: "output-email",
      text: "email",
      type: "outputEmail"
    }, {
      key: "output-mqtt",
      text: "mqtt",
      type: "outputMqtt"
    }, {
      key: "output-tcp",
      text: "tcp",
      type: "outputTcp"
    }]
  }, {
    key: "requestresponse",
    icon: "ele-item-requestresponse",
    text: "请求/应答",
    children: [{
      key: "requestresponse-http",
      text: "http request",
      type: "requestresponseHttp"
    }, {
      key: "requestresponse-tcp",
      text: "tcp request",
      type: "requestresponseTcp"
    }]
  }],
  _linkList = [{
    key: "solid-link",
    type: "solid",
    text: "实线",
    icon: "link-item-solid"
  }, {
    key: "dashed-link",
    type: "solid",
    text: "虚线",
    icon: "link-item-dashed"
  }],
  _statusCatalog = [{
    key: "trigger",
    type: "trigger",
    text: "触发器",
    icon: "ele-catalog-trigger"
  }],
  completeData = function(e) {
    return e.map(function(e) {
      return (e.children || []).map(function(e) {
        e.icon = (0, _amosTool.parseText)(stageIconPath, {
          iconName: e.key
        })
      }), e
    })
  },
  nodelList = completeData(_nodelList);
exports.nodelList = nodelList;
var linkList = completeData(_linkList);
exports.linkList = linkList;
var catalogOperatorIcon = "/src/assets/iot/rule/ele-catalog-operator.png";
exports.catalogOperatorIcon = catalogOperatorIcon;
var statusCatalog = completeData(_statusCatalog);
exports.statusCatalog = statusCatalog;
var eleType = {
  datanodeDevice: "datanodeDevice",
  datanodeCurrentUser: "datanodeCurrentUser",
  datanodeSubUser: "datanodeSubUser",
  datanodeTask: "datanodeTask",
  datanodeView: "datanodeView",
  alarmAll: "alarmAll",
  alarmQuota: "alarmQuota",
  alarmCollect: "alarmCollect",
  alarmDeviceOffline: "alarmDeviceOffline",
  outputEmail: "outputEmail",
  outputMqtt: "outputMqtt",
  outputTcp: "outputTcp"
};
exports.eleType = eleType;
var ELE_ADD_TOPIC = {
  eleAdd: "ELE_ADD",
  action: "ELE_ADD.ACTION",
  condition: "ELE_ADD.CONDITION",
  common: "ELE_ADD.COMMON",
  sink: "ELE_ADD.SINK",
  object: "ELE_ADD.OBJECT",
  status: "ELE_ADD.STATUS",
  custom: "ELE_ADD.CUSTOM",
  actionlist: "ELE_ADD.ACTIONLIST",
  trigger: "ELE_ADD.TRIGGER",
  flowAction: "ELE_ADD.FLOWACTION",
  note: "ELE_ADD.NOTE"
};
exports.ELE_ADD_TOPIC = ELE_ADD_TOPIC;
var ELE_DEL_TOPIC = {
  eleDel: "ELE_DEL",
  action: "ELE_DEL.ACTION",
  condition: "ELE_DEL.CONDITION",
  common: "ELE_DEL.COMMON",
  sink: "ELE_DEL.SINK",
  object: "ELE_DEL.OBJECT",
  status: "ELE_DEL.STATUS",
  custom: "ELE_DEL.CUSTOM",
  actionlist: "ELE_DEL.ACTIONLIST",
  trigger: "ELE_DEL.TRIGGER",
  flowAction: "ELE_DEL.FLOWACTION",
  note: "ELE_DEL.NOTE"
};
exports.ELE_DEL_TOPIC = ELE_DEL_TOPIC;
var ELE_ENTRY_TOPIC = {
  eleEntry: "ELE_ENTRY",
  status: "ELE_ENTRY.STATUS",
  trigger: "ELE_ENTRY.TRIGGER"
};
exports.ELE_ENTRY_TOPIC = ELE_ENTRY_TOPIC;
var ELE_CATALOG_TOPIC = {
  NORMAL: "ELE_CATALOG"
};
exports.ELE_CATALOG_TOPIC = ELE_CATALOG_TOPIC;
var locale = {
  action: "动作",
  flowAction: "动作",
  condition: "条件",
  common: "默认",
  sink: "Sink",
  source: "对象",
  transform: "转换",
  custom: "自定义",
  object: "对象",
  status: "状态",
  actionlist: "动作串",
  trigger: "触发器",
  note: "注释"
};
exports.locale = locale;
var getEleTopic = function() {
    var e = Object.keys(eleType),
      t = {
        stage: "TOIP_STAGE"
      };
    return e.forEach(function(e) {
      t[e] = "TOIP_STAGE.ELE_".concat(eleType[e].toUpperCase())
    }), t
  },
  eleTypeTopic = getEleTopic();
exports.eleTypeTopic = eleTypeTopic;
var isTriggerEle = function(e) {
  return 0 === e.indexOf(eleTypeTopic.trigger)
};
exports.isTriggerEle = isTriggerEle;
var isFlowActionEle = function(e) {
  return 0 === e.indexOf(eleTypeTopic.flowAction)
};
exports.isFlowActionEle = isFlowActionEle;
var stagePosition = {
  spaceX: 110,
  spaceY: 60,
  defaultSpaceY: -150,
  ratio_1: 1,
  ratio_2: 1,
  ratio_3: 3
};
exports.stagePosition = stagePosition;
var catalogPool = {
  object: ["status", "note", "lineDashed", "lineSolid"],
  status: ["status", "note", "lineDashed", "lineSolid"],
  trigger: ["flowAction", "note", "lineDashed", "lineSolid"],
  flowAction: ["note", "lineDashed", "lineSolid"]
};
exports.catalogPool = catalogPool;
var eleCatalogIconPrefix = "/src/assets/rules/stage/ele-catalog-{icon}.png";
exports.eleCatalogIconPrefix = eleCatalogIconPrefix;
var completeCatalogIcon = function(e) {
  return "/src/assets/rules/stage/ele-catalog-".concat(e, ".png")
};
exports.completeCatalogIcon = completeCatalogIcon;
var completeItemTypeIcon = function(e) {
  return (0, _amosTool.parseText)(stageIconPath, {
    iconName: e
  })
};
exports.completeItemTypeIcon = completeItemTypeIcon;
var isDragEle = function(e) {
  e = 0 < arguments.length && void 0 !== e ? e : "";
  return !(!eleType[e] || "" === eleType[e])
};
exports.isDragEle = isDragEle;
var isDragLink = function(e) {
  e = 0 < arguments.length && void 0 !== e ? e : "";
  return "lineDashed" === e || "lineSolid" === e
};
exports.isDragLink = isDragLink;
var isStatusDragLink = function(e) {
  return e && e.className && -1 < e.className.indexOf("status-ele")
};
exports.isStatusDragLink = isStatusDragLink;
var transferDropData = function(e) {
  var t = 0 < arguments.length && void 0 !== e ? e : "";
  if (-1 < t.indexOf("#")) {
    e = t.split("#");
    return {
      nodeType: e[0],
      sourceId: e[1]
    }
  }
  return {
    nodeType: t
  }
};
exports.transferDropData = transferDropData;
var ELE_UPDATE_TOPIC = {
  eleUpdate: "ELE_UPDATE",
  action: "ELE_UPDATE.ACTION",
  condition: "ELE_UPDATE.CONDITION",
  common: "ELE_UPDATE.COMMON",
  sink: "ELE_UPDATE.SINK",
  object: "ELE_UPDATE.OBJECT",
  status: "ELE_UPDATE.STATUS",
  custom: "ELE_UPDATE.CUSTOM",
  actionlist: "ELE_UPDATE.ACTIONLIST",
  trigger: "ELE_UPDATE.TRIGGER",
  flowAction: "ELE_UPDATE.FLOWACTION",
  note: "ELE_UPDATE.NOTE"
};
exports.ELE_UPDATE_TOPIC = ELE_UPDATE_TOPIC;
var TREE_FETCH_TOPIC = {
  treeFetch: "TREE_FETCH",
  action: "TREE_FETCH.ACTION",
  condition: "TREE_FETCH.CONDITION",
  common: "TREE_FETCH.COMMON",
  sink: "TREE_FETCH.SINK",
  object: "TREE_FETCH.OBJECT",
  status: "TREE_FETCH.STATUS",
  custom: "TREE_FETCH.CUSTOM",
  actionlist: "TREE_FETCH.ACTIONLIST",
  trigger: "TREE_FETCH.TRIGGER",
  flowAction: "TREE_FETCH.FLOWACTION",
  note: "TREE_FETCH.NOTE"
};
exports.TREE_FETCH_TOPIC = TREE_FETCH_TOPIC;
var typeValue = function(e) {
  return ["datanodeDevice", "datanodeCurrentUser", "datanodeSubUser", "datanodeTask", "datanodeView"].includes(e) ? "source" : ["alarmAll", "alarmQuota", "alarmCollect", "alarmDeviceOffline"].includes(e) ? "both" : "target"
};
exports.typeValue = typeValue;
