"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.nameInputLength = exports.ImvalueLength = exports.checkImvalue = exports.isNumber = exports.specailChartValidate = exports.mobileNumberValidate = exports.phoneNumberValidate = exports.generalinputValidate = exports.maxLengthValidate = exports.carCodeValidate = exports.rules = exports.outStoreNumberVilidate = exports.numberVilidate = exports.default = void 0;
var _processor = require("../../../utils/processor"),
  validate = _processor.AmosValidate.validate,
  _default = function(e, t, a) {
    return e(t, {
      rules: [{
        required: !0,
        message: a
      }]
    })
  };
exports.default = _default;
var numberVilidate = function(e, t, a) {
  !t || /^(0|([1-9]+[0-9]*))(\.(0|([0-9]*)))?$/.test(t) ? a() : a([new Error("请输入数量！")])
};
exports.numberVilidate = numberVilidate;
var outStoreNumberVilidate = function(e, t, a, r) {
  t ? /^(0|([1-9]+[0-9]*))(\.(0|([0-9]*)))?$/.test(t) ? a < t ? r([new Error("库存数量不足！")]) : r() : r([new Error("请输入数量！")]) : r()
};
exports.outStoreNumberVilidate = outStoreNumberVilidate;
var checkNumber = function(e, t, a) {
    validate(_processor.AmosValidate.naturalRegex, t, a, "输入数据错误,只能输入正整数！")
  },
  rules = {
    rules: [{
      validator: checkNumber
    }]
  };
exports.rules = rules;
var carCodeValidate = function(e, t, a) {
  t && !_processor.AmosValidate.isUsername(t) && a("车辆编码不能出现汉字或特殊字符"), a()
};
exports.carCodeValidate = carCodeValidate;
var maxLengthValidate = function(e, t, a) {
  t && 50 < t.length && a("输入长度不能大于50"), a()
};
exports.maxLengthValidate = maxLengthValidate;
var generalinputValidate = function(e, t, a) {
  t && 32 < t.length && a("输入长度不能大于32"), a()
};
exports.generalinputValidate = generalinputValidate;
var phoneNumberValidate = function(e, t, a) {
  t && !_processor.AmosValidate.isPhone(t) && a("请输入0x-xx11位电话号码"), a()
};
exports.phoneNumberValidate = phoneNumberValidate;
var mobileNumberValidate = function(e, t, a) {
  t && !_processor.AmosValidate.isMobile(t) && a("请输入手机号"), a()
};
exports.mobileNumberValidate = mobileNumberValidate;
var specailChartValidate = function(e, t, a, r) {
  t && /[@~`!#$%^&*()_+=<>?/|:;\""]/.test(t) && a("".concat(r, "不能出现特殊字符 ")), a()
};
exports.specailChartValidate = specailChartValidate;
var isNumber = function(e, t, a) {
  t && !_processor.AmosValidate.isNum(t) && a("只能输入数字"), a()
};
exports.isNumber = isNumber;
var checkImvalue = function(e, t, a) {
  validate(_processor.AmosValidate.alphaNumericRegex, t, a, "不能出现汉字！")
};
exports.checkImvalue = checkImvalue;
var ImvalueLength = function(e, t, a) {
  (t && t.length < 2 || t && 19 < t.length) && a("请输入2-20位环信账号"), a()
};
exports.ImvalueLength = ImvalueLength;
var nameInputLength = function(e, t, a) {
  (t && t.length < 2 || t && 19 < t.length) && a("输入长度为2-20!"), a()
};
exports.nameInputLength = nameInputLength;
