"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.registerTypes = exports.jsPlumbOptions = exports.targetEndpoint = exports.sourceEndPoint = exports.endpointTargetType = exports.endpointSourceType = exports.connectorType = exports.lines = exports.colors = exports.allAroundAnchor = exports.allCenterAroundAnchor = void 0;
var _amosJsplumb = require("amos-jsplumb"),
  Anchors = _amosJsplumb.placement.Anchors,
  allCenterAroundAnchor = [Anchors.TopCenter, Anchors.RightMiddle, Anchors.BottomCenter, Anchors.LeftMiddle];
exports.allCenterAroundAnchor = allCenterAroundAnchor;
var allAroundAnchor = [Anchors.Top, Anchors.Right, Anchors.Bottom, Anchors.Left];
exports.allAroundAnchor = allAroundAnchor;
var colors = {
  basic: "#345FA6",
  dotFill: "#345FA6",
  dotStroke: "#345FA6",
  startDrawLine: "#345FA6",
  line: "#345FA6",
  lineActived: "#345FA6",
  dotColor: "#345FA6",
  epTarget: "",
  epSource: "",
  hoverColor: "#345FA6"
};
exports.colors = colors;
var lines = {
    thin: 1,
    normal: 2,
    mid: 3,
    large: 4,
    most: 5
  },
  connectorPaintStyle = {
    strokeWidth: (exports.lines = lines).normal,
    stroke: colors.line,
    joinstyle: "round",
    outlineStroke: "transparent",
    outlineWidth: lines.normal
  },
  connectorHoverStyle = {
    strokeWidth: lines.mid,
    stroke: colors.lineActived,
    outlineWidth: lines.most,
    outlineStroke: "white"
  },
  endpointHoverStyle = {
    fill: colors.lineActived,
    stroke: colors.lineActived
  },
  connectorType = {
    Flowchart: ["Flowchart", {
      stub: [40, 60],
      gap: 10,
      cornerRadius: 5,
      alwaysRespectStubs: !0
    }],
    Bezier: ["Bezier", {
      stub: 0,
      curviness: 150
    }],
    StateMachine: ["StateMachine", {
      curviness: 10,
      margin: 5,
      proximityLimit: 80,
      loopbackRadius: 25,
      showLoopback: !0,
      orientation: "clockwise"
    }],
    Straight: ["Straight", {
      stub: 0,
      sourceStub: 10,
      targetStub: 10,
      gap: 0,
      sourceGap: 5,
      targetGap: 5
    }]
  };
exports.connectorType = connectorType;
var endpointSourceType = {
  Blank: "Blank",
  Dot: ["Dot", {
    radius: 1
  }],
  Image: ["Image", {
    src: "/src/assets/iot/topo/end.png"
  }],
  Rectangle: ["Rectangle", {
    width: 10,
    height: 10,
    cssClass: "resource-type"
  }]
};
exports.endpointSourceType = endpointSourceType;
var endpointTargetType = {
  Blank: "Blank",
  Dot: ["Dot", {
    radius: 1
  }],
  Image: ["Image", {
    src: "/src/assets/iot/topo/end.png"
  }],
  Rectangle: ["Rectangle", {
    width: 10,
    height: 10,
    cssClass: "target-type"
  }]
};
exports.endpointTargetType = endpointTargetType;
var useConnector = connectorType.Bezier,
  sourceEndPoint = {
    endpoint: endpointSourceType.Rectangle,
    maxConnections: -1,
    isSource: !0,
    connector: useConnector,
    connectorStyle: connectorPaintStyle,
    dragOptions: {}
  };
exports.sourceEndPoint = sourceEndPoint;
var targetEndpoint = {
  endpoint: endpointTargetType.Rectangle,
  paintStyle: {
    fill: "#7AB02C",
    radius: 7
  },
  hoverPaintStyle: endpointHoverStyle,
  maxConnections: -1,
  dropOptions: {
    hoverClass: "hover",
    activeClass: "active"
  },
  isTarget: !0
};
exports.targetEndpoint = targetEndpoint;
var jsPlumbOptions = {
  PaintStyle: connectorPaintStyle,
  ConnectionOverlays: [
    ["Arrow", {
      id: "arrow",
      location: 1,
      foldback: .8,
      width: 10,
      length: 15
    }]
  ],
  Connector: useConnector,
  Endpoint: endpointSourceType.Dot,
  EndpointHoverStyle: endpointHoverStyle,
  LogEnabled: !1,
  MaxConnections: 1,
  ReattachConnections: !1
};
exports.jsPlumbOptions = jsPlumbOptions;
var registerTypes = {
  connections: {
    dotted: {
      paintStyle: {
        dashstyle: "3 5",
        outlineStroke: "transparent",
        stroke: colors.dotColor,
        strokeWidth: lines.normal
      }
    },
    selected: {
      paintStyle: {
        dashstyle: "solid",
        strokeWidth: lines.mid,
        outlineStroke: "transparent",
        outlineWidth: lines.mid,
        stroke: colors.lineActived
      }
    }
  },
  endpoints: {}
};
exports.registerTypes = registerTypes;
