"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.default = void 0;
var _react = _interopRequireWildcard(require("react")),
  _propTypes = _interopRequireDefault(require("prop-types")),
  _processor = require("./../../common/utils/processor"),
  _amosAntd = require("amos-antd"),
  _amosFramework = require("amos-framework"),
  _validate = require("./../../common/utils/validate");

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}

function _getRequireWildcardCache() {
  if ("function" != typeof WeakMap) return null;
  var e = new WeakMap;
  return _getRequireWildcardCache = function() {
    return e
  }, e
}

function _interopRequireWildcard(e) {
  if (e && e.__esModule) return e;
  if (null === e || "object" !== _typeof(e) && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache();
  if (t && t.has(e)) return t.get(e);
  var r, a, n = {},
    o = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (r in e) Object.prototype.hasOwnProperty.call(e, r) && ((a = o ? Object.getOwnPropertyDescriptor(e, r) : null) && (a.get || a.set) ? Object.defineProperty(n, r, a) : n[r] = e[r]);
  return n.default = e, t && t.set(e, n), n
}

function _typeof(e) {
  return (_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
    return typeof e
  } : function(e) {
    return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
  })(e)
}

function _extends() {
  return (_extends = Object.assign || function(e) {
    for (var t = 1; t < arguments.length; t++) {
      var r, a = arguments[t];
      for (r in a) Object.prototype.hasOwnProperty.call(a, r) && (e[r] = a[r])
    }
    return e
  }).apply(this, arguments)
}

function _classCallCheck(e, t) {
  if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
}

function _defineProperties(e, t) {
  for (var r = 0; r < t.length; r++) {
    var a = t[r];
    a.enumerable = a.enumerable || !1, a.configurable = !0, "value" in a && (a.writable = !0), Object.defineProperty(e, a.key, a)
  }
}

function _createClass(e, t, r) {
  return t && _defineProperties(e.prototype, t), r && _defineProperties(e, r), e
}

function _inherits(e, t) {
  if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function");
  e.prototype = Object.create(t && t.prototype, {
    constructor: {
      value: e,
      writable: !0,
      configurable: !0
    }
  }), t && _setPrototypeOf(e, t)
}

function _setPrototypeOf(e, t) {
  return (_setPrototypeOf = Object.setPrototypeOf || function(e, t) {
    return e.__proto__ = t, e
  })(e, t)
}

function _createSuper(r) {
  var a = _isNativeReflectConstruct();
  return function() {
    var e, t = _getPrototypeOf(r);
    return _possibleConstructorReturn(this, a ? (e = _getPrototypeOf(this).constructor, Reflect.construct(t, arguments, e)) : t.apply(this, arguments))
  }
}

function _possibleConstructorReturn(e, t) {
  return !t || "object" !== _typeof(t) && "function" != typeof t ? _assertThisInitialized(e) : t
}

function _assertThisInitialized(e) {
  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return e
}

function _isNativeReflectConstruct() {
  if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
  if (Reflect.construct.sham) return !1;
  if ("function" == typeof Proxy) return !0;
  try {
    return Date.prototype.toString.call(Reflect.construct(Date, [], function() {})), !0
  } catch (e) {
    return !1
  }
}

function _getPrototypeOf(e) {
  return (_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(e) {
    return e.__proto__ || Object.getPrototypeOf(e)
  })(e)
}

function _defineProperty(e, t, r) {
  return t in e ? Object.defineProperty(e, t, {
    value: r,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[t] = r, e
}
var FormItem = _amosAntd.Form.Item,
  Option = _amosFramework.Select.Option,
  RadioGroup = _amosAntd.Radio.Group,
  userNameText = "用户名",
  nameText = "姓名",
  statusText = "用户状态",
  companyIdText = "所属单位",
  departmentIdText = "所属部门",
  roleIdText = "角色",
  emailText = "Email",
  mobileText = "手机",
  telephoneText = "固定电话",
  statusOptions = [{
    name: "enable",
    value: 0,
    text: "启用"
  }, {
    name: "disable",
    value: 1,
    text: "禁用"
  }],
  nameErrorText = "用户名不能为空！",
  otherNameErrorText = "姓名不能为空！",
  companyErrorText = "所属单位不能为空！",
  roleErrorText = "角色不能为空！",
  dataToTree = function t(e) {
    (0 < arguments.length && void 0 !== e ? e : []).map(function(e) {
      e.label = e.text, e.key = e.id, e.value = e.id, e.children && t(e.children)
    })
  },
  UserAddEdit = function() {
    _inherits(r, _react.Component);
    var t = _createSuper(r);

    function r(e) {
      var n;
      return _classCallCheck(this, r), _defineProperty(_assertThisInitialized(n = t.call(this, e)), "getRole", function() {
        n.props.getAllRoleAction()
      }), _defineProperty(_assertThisInitialized(n), "getOrgData", function(e) {
        e = e.company;
        e && n.getDepartment(e.id)
      }), _defineProperty(_assertThisInitialized(n), "getDepartment", function(e) {
        n.props.getDepartmentByCompanyAction(e)
      }), _defineProperty(_assertThisInitialized(n), "checkId", function(e, t, r) {
        t && !_processor.AmosValidate.isNum(t) ? r("ID只能是数字格式的！") : r()
      }), _defineProperty(_assertThisInitialized(n), "checkMobile", function(e, t, r) {
        t && !_processor.AmosValidate.isMobile(t) ? r("请输入正确的手机号格式！") : r()
      }), _defineProperty(_assertThisInitialized(n), "checkTelephone", function(e, t, r) {
        t && !_processor.AmosValidate.isPhone(t) ? r("请输入正确的固定电话格式！") : r()
      }), _defineProperty(_assertThisInitialized(n), "checkEmail", function(e, t, r) {
        t && (!_processor.AmosValidate.isEmail(t) || 25 < t.length) ? r("请输入正确的邮箱格式！") : r()
      }), _defineProperty(_assertThisInitialized(n), "checkPassword", function(e, t, r) {
        t && !_processor.AmosValidate.isPassword(t) ? r("请输入正确的密码格式！") : r()
      }), _defineProperty(_assertThisInitialized(n), "checkRePassword", function(e, t, r) {
        var a = n.props.parentform.getFieldValue;
        t && t !== a("password") ? r("两次输入密码不一致！") : r()
      }), n.state = {
        companyList: [],
        selectDepartment: "",
        reset: !1
      }, n
    }
    return _createClass(r, [{
      key: "componentWillReceiveProps",
      value: function(e) {
        var t = this,
          e = e.user;
        this.props.user && this.props.user.id == e.id || (this.getOrgData(e), this.props.setHandleReset(function() {
          t.setState({
            reset: !1
          })
        }))
      }
    }, {
      key: "componentDidMount",
      value: function() {
        var e = this;
        this.getRole(), this.props.superiorUnitAction(), this.props.setHandleReset(function() {
          e.setState({
            reset: !1
          })
        })
      }
    }, {
      key: "render",
      value: function() {
        var t = this,
          e = this.props,
          r = e.user,
          a = e.parentform,
          n = e.submit,
          o = e.isEdit,
          l = e.departmentTreeData,
          i = e.allRole,
          s = e.superiorCompanyList,
          u = r.userName,
          d = r.enabled,
          c = r.company,
          p = r.department,
          m = r.role,
          f = r.mobile,
          _ = r.email,
          y = r.name,
          e = r.telephone,
          r = c && c.id ? c.id + "" : null,
          c = p ? p.id : null,
          p = m ? m.id : null,
          m = a.getFieldProps,
          u = m("userName", {
            initialValue: "" == u ? void 0 : u,
            rules: [{
              required: !0,
              message: nameErrorText
            }, {
              validator: (0, _validate.textLengthValidate)(255, 2)
            }]
          }),
          y = m("name", {
            initialValue: "" == y ? void 0 : y,
            rules: [{
              required: !0,
              message: otherNameErrorText
            }, {
              validator: (0, _validate.textLengthValidate)(255, 2)
            }]
          }),
          e = (m("mobile", {
            initialValue: "" == f ? null : f,
            rules: [{
              validator: this.checkMobile
            }]
          }), m("telephone", {
            initialValue: "" == e ? null : e,
            rules: [{
              validator: this.checkTelephone
            }]
          }), m("email", {
            initialValue: "" == _ ? null : _,
            rules: [{
              validator: this.checkEmail
            }]
          }), m("companyId", {
            initialValue: r,
            rules: [{
              required: !0,
              message: companyErrorText
            }],
            onChange: function(e) {
              t.getDepartment(e), t.setState({
                reset: !0
              }), a.resetFields(["departmentId"])
            }
          })),
          _ = m("departmentId", {
            initialValue: this.state.reset ? void 0 : "number" == typeof c ? "" + c : null
          }),
          r = m("roleId", {
            initialValue: p ? p + "" : void 0,
            rules: [{
              required: !0,
              message: roleErrorText
            }]
          }),
          c = m("enabled", {
            initialValue: (d ? statusOptions[0] : statusOptions[1]).name
          }),
          p = m("password", {
            initialValue: null,
            rules: [{
              required: o,
              message: "请输入密码"
            }, {
              validator: this.checkPassword
            }]
          }),
          d = m("rePassword", {
            initialValue: null,
            rules: [{
              required: o,
              message: "请输入确认密码"
            }, {
              validator: this.checkRePassword
            }]
          }),
          m = {
            labelCol: {
              span: 7
            },
            wrapperCol: {
              span: 16
            }
          };
        return _react.default.createElement("div", {
          className: "user-add-edit amos-grid-from"
        }, _react.default.createElement(_amosAntd.Form, {
          inline: !0,
          onSubmit: n
        }, _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: userNameText
        }, m), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, u, {
          style: {
            width: 240
          }
        })))), _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: nameText
        }, m), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input"
        }, y, {
          style: {
            width: 240
          }
        }))))), _react.default.createElement("hr", null), _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: companyIdText
        }, m), _react.default.createElement(_amosAntd.TreeSelect, _extends({
          instanceId: "user-company",
          showSearch: !0,
          className: "amos-grid-form-select",
          style: {
            width: 240
          },
          dropdownStyle: {
            maxHeight: 250,
            overflow: "auto"
          },
          treeData: s,
          placeholder: "所有单位",
          notFoundContent: "无匹配结果",
          treeDefaultExpandAll: !0,
          treeNodeFilterProp: "title"
        }, e)))), _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: departmentIdText
        }, m), _react.default.createElement(_amosAntd.TreeSelect, _extends({
          instanceId: "user-department"
        }, _, {
          allowClear: !0,
          showSearch: !0,
          optionFilterProp: "children",
          treeNodeFilterProp: "title",
          dropdownStyle: {
            maxHeight: 300,
            overflow: "auto"
          },
          style: {
            width: 240
          },
          treeData: l,
          notFoundContent: "无匹配结果"
        }))))), o ? _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: "密码"
        }, m), _react.default.createElement(_amosAntd.Input, {
          className: "amos-grid-form-input",
          style: {
            width: 0,
            height: 0,
            padding: 0,
            border: 0,
            position: "absolute"
          }
        }), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input",
          type: "password"
        }, p, {
          style: {
            width: 240
          }
        })))), _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: "确认密码"
        }, m), _react.default.createElement(_amosAntd.Input, _extends({
          className: "amos-grid-form-input",
          type: "password"
        }, d, {
          style: {
            width: 240
          }
        }))))) : null, _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(_amosAntd.Col, {
          span: 12
        }, _react.default.createElement(FormItem, _extends({
          label: roleIdText
        }, m), _react.default.createElement(_amosFramework.Select, _extends({
          instanceId: "user-role",
          className: "amos-grid-form-select",
          showSearch: !0,
          optionFilterProp: "children"
        }, r, {
          style: {
            width: 240,
            height: "32px"
          }
        }), i.map(function(e) {
          return _react.default.createElement(Option, {
            key: "".concat(e.id, "option"),
            value: e.id + ""
          }, e.name)
        }))))), _react.default.createElement("hr", null), _react.default.createElement(_amosAntd.Row, null, _react.default.createElement(FormItem, _extends({
          label: statusText
        }, {
          labelCol: {
            span: 3
          },
          wrapperCol: {
            span: 16
          }
        }), _react.default.createElement(RadioGroup, _extends({}, c, {
          style: {
            width: 240
          }
        }), statusOptions.map(function(e) {
          return _react.default.createElement(_amosAntd.Radio, {
            key: "".concat(e.name, "Radio"),
            value: e.name
          }, e.text)
        }))))))
      }
    }]), r
  }();
UserAddEdit.displayName = "UserAddEdit", UserAddEdit.propTypes = {
  user: _propTypes.default.object,
  submit: _propTypes.default.func,
  cancel: _propTypes.default.func,
  getDepartmentByCompanyAction: _propTypes.default.func,
  parentform: _propTypes.default.any,
  superiorUnitAction: _propTypes.default.func,
  allRole: _propTypes.default.array,
  superiorCompanyList: _propTypes.default.any,
  getAllRoleAction: _propTypes.default.func,
  departmentTreeData: _propTypes.default.array,
  isEdit: _propTypes.default.bool
}, UserAddEdit.defaultProps = {
  departmentTreeData: [],
  allRole: [],
  superiorCompanyList: [],
  user: {
    identificationId: "",
    userName: "",
    enabled: !0,
    company: "",
    department: {},
    role: {},
    mobile: "",
    password: "",
    email: ""
  }
};
var _default = UserAddEdit;
exports.default = UserAddEdit, module.exports = exports.default;
