import { parseText } from 'amos-tool';
import * as endConf from 'amos-processor/lib/config/endconf';
import { getToken, getUser } from '../utils/request';

const AmosConfig = endConf.AmosConfig;

const dataAnalysis = AmosConfig.outterURI.dataAnalysis;

const mainIneerUrl = AmosConfig.outterURI.mainIneer;
const onePageUrl = AmosConfig.outterURI.onePage;
const digitalPlanUrl = AmosConfig.outterURI.digitalPlan;
const giotUrl = AmosConfig.outterURI.giot;
const dispatchUrl = AmosConfig.outterURI.dispatch;
const analysisUrl = AmosConfig.outterURI.analysis;
const forum = AmosConfig.outterURI.forum;
const helpCenter = AmosConfig.outterURI.helpCenter;

export function mainIneer(){
  return mainIneerUrl;
}

export function onePage(){
  return parseText(onePageUrl, {
    user: getUser(),
    token: getToken()
  });
}
export function digitalPlan(){
  return parseText(digitalPlanUrl, {
    user: getUser(),
    token: getToken()
  });
}
export function giot(){
  return parseText(giotUrl, {
    user: getUser(),
    token: getToken()
  });
}
export function dispatch(){
  return parseText(dispatchUrl, {
    user: getUser(),
    token: getToken()
  });
}
export function analysis(){
  return parseText(analysisUrl, {
    user: getUser(),
    token: getToken()
  });
}

export function dataAnaysisUrl(){
  return dataAnalysis;
}

export function forumUrl(){
  return forum;
}

export function helpCenterUrl(){
  return helpCenter;
}
