import { combineRoutes } from 'amos-pluggable';
// import { parseCusotmRoutes } from './parsePlugin';

import StageLayout from './../view/ruleDesign/ruleStatge';

/**
 * 系统自定义路由
 */
const customRoutes = [
  { path: 'ruledeploy/:libkey', component: StageLayout, parent: 'ruledesign' }
];

/**
 * path mapping
 *
 * import { parseText } from 'amos-tool';
 * const ruledeploy = parseText(pathMapping.ruledeploy, { libkey });
 */
export const pathMapping = {
  // ruledeploy: '/main/config/rulecenter/ruledeploy/{libkey}'
  ruledeploy: '/main/monitor/ruledesign/ruledeploy/{libkey}'
};

/**
 *  将自定义路由添加到主路由上
 * @param {*} mainRoutes
 */
const addCustomRoutes = (mainRoutes) => combineRoutes(mainRoutes, customRoutes);

export default addCustomRoutes;
