// import {
//   Department,
//   Menu,
//   Role,
//   SystemDic
// } from 'amos-security/lib';

// import parsePlugin from './parsePlugin';
import RegionList from './../view/region';
import Login from './../view/login';
import RootView from './../view/mainframe';
import PluginCore from './../view/mainframe/PluginCore';
import Config from './../view/config';
import DeviceInterface from './../view/deviceInterface';
import DeviceProtocol from './../view/deviceProtocol';
import DeviceManage from './../view/deviceManage';
import RuleManage from './../view/ruleManage';
import TopoManage from './../view/topoManage';
import KunShan from './../view/topoManage/KunShan';
import HistoricalData from './../view/historicalData';
import Monitor from './../view/monitor';
import HistoryAlarm from './../view/historyAlarm';
import RecentAlarm from './../view/recentAlarm';
import RuleDesign from './../view/ruleDesign';
import DeviceCustom from './../view/deviceCustom';
import OnlineMonitor from './../view/onlineMonitor';
import AlarmManage from './../view/alarmManage';

import Overview from './../view/zonglan/home';
import EmptyPage from './../view/common/page/EmptyPage';
import CreateEquipment from './../view/createEquipment';
import SectionStoreRoom from './../view/sectionStoreRoom';
import PLCManager from './../view/plcManager';
import IECClient from './../view/iec/client';
import IECServer from './../view/iec/server';

const Routes = {
  main: RootView,
  pluginCore: PluginCore,
  config: Config,
  monitor: Monitor,
  onlineMonitor: OnlineMonitor,
  deviceCustom: DeviceCustom,
  alarmManage: AlarmManage, //告警管理路由配置
  deviceInterface: DeviceInterface, //设备接口路由配置
  deviceProtocol: DeviceProtocol, //设备协议路由配置
  deviceManage: DeviceManage,
  ruleManage: RuleManage, //任务管理路由配置
  topoManage: TopoManage,
  kunshan: KunShan,
  historicalData: HistoricalData,
  historyAlarm: HistoryAlarm, //历史告警路由配置
  recentAlarm: RecentAlarm, //当前告警路由配置
  ruledesign: RuleDesign,
  overview: Overview,
  createEquipment: CreateEquipment,
  sectionStoreRoom: SectionStoreRoom,
  plcManager: PLCManager,
  iec104client: IECClient,
  iec104server: IECServer
};

const pageCompontent = (key) => {
  return Routes[key] || EmptyPage;
};

export {
  Login,
  RegionList,
  RootView,
  // UserInfo,
  Overview
};

export default pageCompontent;
