import formatUrl from 'amos-processor/lib/utils/urlFormat';
import Url from '../consts/urlConsts';
import { commonGet, commonPost, commonDelete, commonPut } from '../utils/request';

/**
 * 获取所有的rulelib
 */
export const rulelibListAction = (requestParam) => {
  return commonPost(Url.rulelibListUrl,requestParam);
};

export const initStageView = (objId) => {
  const url = `${Url.initStageViewUrl}/${objId}`;
  return commonGet(url);
};

export const saveStageView = (viewData) => {
  return commonPost(Url.saveStageViewUrl, viewData);
};

export const queryRuleSubObj = (subObjId) => {
  const url = formatUrl(Url.queryRuleSubObjUrl, { subObjId });
  return commonGet(url);
};

/**
 * 添加元素
 * @param {object} data {
 *  id: '',
 *  subObjId: '',
 *  sourceId: '',
 *  config: {
 *    label: '', ype: '', style: {}
 *  }
 * }
 */
export const addViewNode = (data) => {
  return commonPost(Url.addViewNodeUrl, data);
};

/**
 * 添加链路
 * @param {object} data {
 *  oid: '',
 *  sourceId: '',
 *  targetId: '',
 * }
 */
export const addViewLink = (data) => {
  return commonPost(Url.addViewLinkUrl, data);
};

/**
 * 更新节点名称
 * @param {object} data {
 *  id: '',
 *  label: ''
 * }
 */
export const updateNodeLabel = (data) => {
  return commonPut(Url.updateNodeLabelUrl, data);
};

/**
 * 删除元素节点
 * @param {string} nodeId
 */
export const delViewNode = (nodeId) => {
  const url = `${Url.delViewNodeUrl}/${nodeId}`;
  return commonDelete(url);
};

/**
 * 获取对象标签集合
 */
export const queryObjectTagsAction = (objId) => {
  const url = formatUrl(Url.queryObjectTagsUrl, { objId });
  return commonGet(url);
};

/**
 * 获取对象类型集合
 */
export const queryObjectTypesAction = (objId) => {
  const url = formatUrl(Url.queryObjectTypesUrl, { objId });
  return commonGet(url);
};

/**
* 删除子对象
*/
export const removeSubObjectAction = (subObjId) => {
  const url = `${Url.removeObjUrl}/${subObjId}`;
  return commonDelete(url);
};
/**
* 启用/停用子对象
*/
export const startUseSubObjectAction = (subObjId) => {
  const url = `${Url.changeRule}/${subObjId}`;
  return commonPut(url);
};
/**
*  启用/停用对象
*/
export const startUseObjectAction = (status) => {
  const url = `${Url.changeAllRule}/${status}`;
  return commonPut(url);
};
/**
*  添加对象
*/
export const addSubObjectAction = (subObject) => {
  const url = formatUrl(Url.addSingleRule);
  return commonPost(url, subObject);
};
/**
*  编辑对象
*/
export const updateSubObjectAction = (subObject) => {
  const url = formatUrl(Url.editSingleRule);
  return commonPut(url, subObject);
};
/**
*  获取触发规则对象根据触发器元素id
*/
export const queryTriggerRuleAction = (elementId) => {
  const url = formatUrl(Url.queryTriggerUrl, { elementId });
  return commonGet(url);
};

/**
 * 更新节点
 * @param {object} data {
 *  id: '',
 *  label: ''
 * }
 */
export const updateNode = (data) => {
  return commonPut(Url.updateNodeUrl, data);
};

export const fetchNodeConfigAction = (nodeId) => {
  const url = `${Url.fetchNodeConfig}/${nodeId}`;
  return commonGet(url);
};

/**
 * 获取规则节点元素
 */
export const fetchRuleElementsAction = () => {
  return commonGet(Url.getRuleElements);
};
