import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { commonGet, commonPost } from '../utils/request';
import { secExtUrl } from './../consts/urlConsts';

export const getCurrentUser = () => {
  return commonGet(secExtUrl.currentUserUrl);
};

export const getSystemAllMenu = (code, userId) => {
  return commonGet(formatUrl(secExtUrl.systemMenusUrl, { code, userId }));
};

export const login = (code, userId) => {
  return commonPost(formatUrl(secExtUrl.loginUrl), { code, userId });
};

export const getPermissionsCompany = () => {
  return commonGet(formatUrl(secExtUrl.systemMenusUrl));
};

/**
 * 获取当前角色权限菜单
 * @param {*} roleSeq 角色Id
 */
export const getPermissionsMenus = (roleSeq) => {
  return commonGet(formatUrl(secExtUrl.permissionsMenusUrl, { roleSeq }));
};

// export const getPermissionsMenus = () => {
//   return commonGet(formatUrl(secExtUrl.permissionsMenusUrl));
// };
