import formatUrl from 'amos-processor/lib/utils/urlFormat';
import Url from '../consts/urlConsts';
import { commonGet, commonPost, commonDelete, commonPut } from '../utils/request';

/**
 * 获取符合条件的视图
 */
export const subViewListAction = () => {
  return commonGet(Url.fetchSubgraphInfos);
};

/**
 * 获取视图下设备
 */
export const subEgpListAction = (name) => {
  const url = `${Url.fetchSubgraphEquipments}/${name}`;
  return commonGet(url);
};

/**
 * 获取视图下设备
 */
export const fetchSubEgpListAction = (id) => {
  const url = `${Url.fetchSingleSubgraphEquipments}/${id}`;
  return commonGet(url);
};


/**
 * 根据公司orgCode获取下属视图
 */
export const subviewByOrgCodeAction = (orgCode) => {
  const url = `${Url.getSubviewByOrgCode}/${orgCode}`;
  return commonGet(url);
};

/**
 * 根据公司id获取公司信息
 */
export const fetchCompanyById = (id) => {
  const url = `${Url.fetchCompanyById}/${id}`;
  return commonGet(url);
};


/**
 * 编辑公司背景
 */
export const editOrgImgAction = (param) => {
  return commonPost(Url.editOrgImgUrl, param);
};

/**
 * 获取公司背景
 */
export const fetchOrgImgsAction = (orgCode) => {
  const url = `${Url.fetchOrgImgs}/${orgCode}`;
  return commonGet(url);
};

/**
 * 获取公司背景
 */
export const fetchSimpleOrgImgsAction = (orgCode) => {
  const url = `${Url.fetchSimpleOrgImgs}/${orgCode}`;
  return commonGet(url);
};


/**
 * 编辑视图背景
 * @param {*} param
 */
export const editSubviewImgAction = (param) => {
  return commonPost(Url.editSubviewImg, param);
};

/**
 * 保存/编辑视图信息
 */
export const editSubviewAction = (param) => {
  return commonPost(Url.addSubgraph, param);
};

/**
 * 更新视图名称
 */
export const updateEquipmentNameAction = (param) => {
  return commonPost(Url.updateNodeName, param);
};

/**
 * 更新设备配置信息
 */
export const updateEquipmentConfigAction = (param) => {
  return commonPost(Url.updateEquipmentConfig, param);
};

/**
 * 新增编辑设备图片
 */
export const addeEditEqpImgAction = (data) => {
  return commonPost(Url.addeEditEqpImg,data);
};
