/**
 * 日期格式化文件
 */
Date.prototype.format = function(format){
  let o = {
    'M+': this.getMonth() + 1, //month
    'd+': this.getDate(), //day
    'h+': this.getHours(), //hour
    'm+': this.getMinutes(), //minute
    's+': this.getSeconds(), //second
    'q+': Math.floor((this.getMonth() + 3) / 3), //quarter
    'S': this.getMilliseconds() //millisecond
  };

  if (/(y+)/.test(format)) {
    format = format.replace(RegExp.$1, `${this.getFullYear()}`.substr(4 - RegExp.$1.length));
  }

  for (let k in o) {
    if (new RegExp(`(${k})`).test(format)) {
      format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : `00${o[k]}`.substr(`${o[k]}`.length));
    }
  }
  return format;
};
/**
 * 根据时间字符串获取时间戳,参数为长时间格式或短时间格式
 * 如：长时间格式：'2016-10-10 12:00:00'
 *     短时间格式：'2016-10-10'
 */
export const strToTime = (str) => {
  str = str.replace(/-/g,'/');
  let date = new Date(str);
  return date.getTime();
};
/**
 * 根据时间戳获取该时间的长时间格式字符串
 */
export const dateToStr = (time) => {
  let date = new Date(time);
  let nowStr = date.format('yyyy-MM-dd hh:mm:ss');
  return nowStr;
};
/**
 * 根据时间戳获取该时间字符串格式，格式如下
 * 03-27（月份和天数）
 */
export const dateToMouthDay = (time) => {
  let date = new Date(time);
  let nowStr = date.format('MM-dd');
  return nowStr;
};
/**
 * 根据时间戳获取该时间字符串格式，格式如下
 * 18:00（小时和分钟）
 */
export const dateToHourMi = (time) => {
  let date = new Date(time);
  let nowStr = date.format('hh:mm');
  return nowStr;
};

/**
 * 根据时间戳获取整点长时间格式字符串，格式如下
 * 2016-10-22 10:00:00
 */
export const dateToHour = (time) => {
  let date = new Date(time);
  let nowStr = date.format('yyyy-MM-dd hh');
  nowStr = `${nowStr}:00:00`;
  return nowStr;
};

/**
 * 获取当前时间的短时间格式字符串
 * 2016-10-22
 */
export const currentDate = () => {
  let d = new Date();
  let res = d.format('yyyy-MM-dd');
  return res;
};
/**
 * 获取当前时间的长时间格式字符串
 * 2016-10-22 12:00:00
 */
export const currentLongDate = () => {
  let d = new Date();
  let res = d.format('yyyy-MM-dd hh:mm:ss');
  return res;
};

/**
 * 获取当前时间格式字符串，格式如下
 * 09时57分（小时和分钟）
 */
export const currentDateHm = () => {
  let d = new Date();
  let res = d.format('hh时mm分');
  return res;
};

/**
 * 获取当前时间格式字符串，格式如下
 * 12-30 12:00:00
 */
export const currentDateMdhms = () => {
  let d = new Date();
  let res = d.format('MM-dd hh:mm:ss');
  return res;
};
/**
 * 根据时间戳获取改时间的如下格式字符串
 * 12-30 12:00
 */
export const dateToNoYS = (time) => {
  let date = new Date(time);
  let nowStr = date.format('MM-dd hh:mm');
  return nowStr;
};
/**
 * 将秒换算成时分秒
 */
export const formatSeconds = (value) => {
  const hour = 3600;
  const minute = 60;
  let result = '';
  if (value){
    let theTime = parseInt(value);// 秒
    let theTime1 = 0;// 分
    let theTime2 = 0;// 小时
    theTime2 = parseInt( theTime / hour );
    theTime1 = parseInt(( theTime % hour ) / minute );
    result = `${theTime2}小时 ${theTime1}分钟`;
  } else {
    result = `请开始分析！`;
  }
  return result;
};
