/* eslint no-magic-numbers: 0 */

export const getMousePos = (event) => {
  const e = event || window.event;
  const scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;
  const scrollY = document.documentElement.scrollTop || document.body.scrollTop;
  const x = e.pageX || e.clientX + scrollX;
  const y = e.pageY || e.clientY + scrollY;
  return { left: x, top: y };
};

export const getCatalogOffset = (domEle = {}) => {
  let box = {
    top: 0,
    left: 0,
    height: 0,
    width: 0
  };

  if (domEle.getBoundingClientRect !== undefined) {
    const clientRect = domEle.getBoundingClientRect();
    const ownerDoc = domEle.ownerDocument;
    const _body = ownerDoc.body;
    const _de = ownerDoc.documentElement;
    const tempTop = _de.clientTop || _body.clientTop || 0;
    const tempLeft = _de.clientLeft || _body.clientLeft || 0;
    box = {
      top: clientRect.top + (window.pageYOffset || (_de && _de.scrollTop) || _body.scrollTop) - tempTop,
      left: clientRect.left + (window.pageXOffset || (_de && _de.scrollLeft) || _body.scrollLeft) - tempLeft,
      width: (clientRect.width === null ? domEle.offsetWidth : clientRect.width) || 0,
      height: (clientRect.height === null ? domEle.offsetHeight : clientRect.height) || 0
    };
  }

  return box;
};

export const getCatalogPanelOffset = (domEle) => {
  const position = getCatalogOffset(domEle);

  return {
    left: position.left + position.width + 20,
    top: position.top
  };
};
