import { Store, utils } from 'amos-tool';
import SysConsts from 'amos-processor/lib/config/consts';
const lsTool = Store.lsTool;

const userConfigs = {
  leftAsideOpenFlag: 'leftAsideOpenFlag',
  rightAsideOpenFlag: 'rightAsideOpenFlag',
  changeLanguageFlag: 'changeLanguageFlag',
  skinName: 'skinName',
  themeColor: 'themeColor'
};

export const changeAssideStatus = (asside, flag) => {
  const result = flag ? 1 : 0;
  if (asside === 'right'){
    lsTool.write(userConfigs.rightAsideOpenFlag, result);
  } else if (asside === 'left'){
    lsTool.write(userConfigs.leftAsideOpenFlag, result);
  }
};

export const getAssideStatus = () => {
  const left = lsTool.read(userConfigs.leftAsideOpenFlag);
  const right = lsTool.read(userConfigs.rightAsideOpenFlag);
  return {
    left: transUndefinedToDefault(left, false),
    right: transUndefinedToDefault(right, false)
  };
};

const transUndefinedToDefault = (val, _default = '') => {
  if (val === 0 || val === '0'){
    return false;
  } else if (val === 1 || val === '1'){
    return true;
  }
  return utils.isEmpty(val) ? _default : val;
};


export const currentUser = () => {
  var e = JSON.parse(lsTool.read(SysConsts.company));
  return {
    api_key: Store.getCookieByName(SysConsts.api_key),
    token: lsTool.read(SysConsts.token),
    userId: lsTool.read(SysConsts.userId),
    userName: lsTool.read(SysConsts.userName),
    nickName: lsTool.read(SysConsts.nickName),
    company: e
  }
}
