import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';

import Pre from './Pre';

class DocWrapper extends Component {

  constructor(props) {
    super(props);
    this.state = {
      codeShow: false
    };
  }

  toggleSource = () => {
    this.setState({
      codeShow: !this.state.codeShow
    });
  }


  render() {
    const { codeShow } = this.state;
    const { children, title, extra, code, descr } = this.props;
    const extraAction = extra ? <span className="doc-descr-extra">{extra}</span> : null;

    const icon = codeShow ? 'code-show' : 'code-hide';
    return (
      <div className="doc-wrapper">
        <div className="doc-descr">
          {title}
          {extraAction}
        </div>
        <div className="doc-example">
          {children}
        </div>
        <div className="doc-source">
          <div className="doc-source-triger">
            <div className="doc-source-descr">{descr}</div>
            <div className="source-triger-btn" onClick={this.toggleSource}><Icon icon={icon} />源码</div>
          </div>
          <div className="doc-source-code">
            {
              codeShow && <Pre>{code}</Pre>
            }
          </div>
        </div>
      </div>
    );
  }
}

DocWrapper.propTypes = {
  children: PropTypes.node,
  title: PropTypes.string,
  extra: PropTypes.node,
  code: PropTypes.any,
  descr: PropTypes.string
};

export default DocWrapper;
