
import { render } from 'react-dom';

/**
 * portal component
 *
 * @param {any} WrappedComponent
 * @param {any} options : { containerKey, visible }
 * @returns enhance Component
 */
export default function(WrappedComponent, options){
  const { containerKey, visible } = options;
  const getContainer = () => {
    return document.getElementById(containerKey);
  };

  if (visible){
    render(WrappedComponent, getContainer());
  }
}
