import React, { Component } from 'react';
import PropTypes from 'prop-types';

const scale = 10;

/**
 * sync component
 *
 * @param {any} WrapperComponent
 * @param {any} options : { url, params: { method, body, header } }
 * @returns enhance Component
 */
export default function(WrapperComponent, options){

  class WhComponent extends Component {

    static propTypes = {
      vh: PropTypes.number,
      vw: PropTypes.number,
      style: PropTypes.object
    };

    render() {
      const { vw, vh, style = {},  ...rest } = this.props;

      if (vw){
        style.width = `${vw * scale}vw`;
      }

      if (vh){
        style.height = `${vh * scale}vh`;
      }


      return (
        <WrapperComponent
          style={style}
          {...rest}
        />
      );
    }
  }

  return WhComponent;
}
