import React, { Component } from 'react';
import PropTypes from 'prop-types';
/**
 * 实现方式筛选
 *
 * @class ComMethodOptionsFilter
 * @extends {Component}
 */
class ComMethodOptionsFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      scriptLangOptions: [],
      clearBtnStyle: 'all-filter-btn selected-btn'
    };
  }

  componentWillReceiveProps(nextProps) {
    let scriptLangOptions = nextProps.scriptLangOptions;
    this.setState({ scriptLangOptions });
  }

  //全清
  delFilter = () => {
    let { scriptLangOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn selected-btn';
    scriptLangOptions.map(option=>{
      option.selected = false;
      option.style = 'all-filter-btn';
    });
    this.setState({ scriptLangOptions,clearBtnStyle });
    this.props.comMethodSelectFunc([]);
  }

  //筛选条件点击事件
  selectClick = (e) => {
    let filterOptionList = [];
    let { scriptLangOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn';
    scriptLangOptions.map(option=>{
      if (option.label === e.target.innerText) {
        option.selected = true;
        option.style = 'all-filter-btn selected-btn';
      }
      if (option.selected) {
        filterOptionList.push(option);
      }
    });
    this.setState({ scriptLangOptions,clearBtnStyle });
    this.props.comMethodSelectFunc(filterOptionList);
  }

  //加载接口通讯方式所有筛选按钮
  AllCommunityOptionFunc = () => {
    let { scriptLangOptions,clearBtnStyle } = this.state;
    let res = [];
    res.push(
      <div key={`clear1`} className={clearBtnStyle} onClick={this.delFilter}>
        <div>不限</div>
      </div>);
    scriptLangOptions.map(option=>{
      res.push(<div key={`scriptLang${option.value}`} className={option.style} onClick={this.selectClick}>{option.label}</div>);
      // if (option.selected) {
      //   clearBtnStyle = 'all-filter-btn selected-btn';
      // }
    });
    return res;
  }

  render() {
    return (
      this.AllCommunityOptionFunc()
    );
  }
}

ComMethodOptionsFilter.propTypes = {
  comMethodSelectFunc: PropTypes.func,
  scriptLangOptions: PropTypes.array
};

export default ComMethodOptionsFilter;
