import React, { Component } from 'react';
import PropTypes from 'prop-types';
/**
 * 接口通讯方式筛选
 *
 * @class CommunityOptionsFilter
 * @extends {Component}
 */
class CommunityOptionsFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      communityOptions: [],
      clearBtnStyle: 'all-filter-btn selected-btn'
    };
  }

  componentWillReceiveProps(nextProps) {
    let communityOptions = nextProps.communityOptions;
    this.setState({ communityOptions });
  }

  //全清
  delFilter = () => {
    let { communityOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn selected-btn';
    communityOptions.map(option=>{
      option.selected = false;
      option.style = 'all-filter-btn';
    });
    this.setState({ communityOptions,clearBtnStyle });
    this.props.communitySelectFunc([]);
  }

  //筛选条件点击事件
  selectClick = (e) => {
    let filterOptionList = [];
    let { communityOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn';
    communityOptions.map(option=>{
      if (option.label === e.target.innerText) {
        if (option.selected) {
          option.selected = false;
          option.style = 'all-filter-btn';
        } else {
          option.selected = true;
          option.style = 'all-filter-btn selected-btn';
        }
      }
      if (option.selected) {
        filterOptionList.push(option);
      }
    });
    //‘不限’选项的样式控制
    if (filterOptionList.length === 0) {
      clearBtnStyle = 'all-filter-btn selected-btn';
    } else {
      clearBtnStyle = 'all-filter-btn';
    }
    this.setState({ communityOptions,clearBtnStyle });
    this.props.communitySelectFunc(filterOptionList);
  }

  //反选‘不限’
  disableAllSelected = () => {
    let clearBtnStyle = 'all-filter-btn selected-btn';
    this.setState({ clearBtnStyle });
  }

  //加载接口通讯方式所有筛选按钮
  AllCommunityOptionFunc = () => {
    let { communityOptions,clearBtnStyle } = this.state;
    let res = [];
    res.push(
      <div key={`0community`} className={clearBtnStyle} onClick={this.delFilter}>
        <div>不限</div>
      </div>);
    communityOptions.map(option=>{
      res.push(<div key={`${option.value}community`} className={option.style} onClick={this.selectClick}>{option.label}</div>);
      // if (option.selected) {
      //   clearBtnStyle = 'all-filter-btn selected-btn';
      // }
    });
    return res;
  }

  render() {
    return (
      this.AllCommunityOptionFunc()
    );
  }
}

CommunityOptionsFilter.propTypes = {
  communitySelectFunc: PropTypes.func,
  communityOptions: PropTypes.array
};

export default CommunityOptionsFilter;
