import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { capacityClassifyEnum } from  './../../deviceManage/common/DeviceEnum';
import { enums2array } from './../../deviceManage/common/DeviceLang';

//能力option数据
let obilityOptionData = [];
enums2array(capacityClassifyEnum).map((item)=>{
  obilityOptionData.push({ value: item.key, label: item.label,selected: false,style: 'all-filter-btn' });
});
/**
 * 能力分类筛选
 *
 * @class ObilityOptionsFilter
 * @extends {Component}
 */
class ObilityOptionsFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      obilityOptions: obilityOptionData,
      clearBtnStyle: 'all-filter-btn selected-btn'
    };
  }

  //全清
  delFilter = () => {
    let { obilityOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn selected-btn';
    obilityOptions.map((option)=>{
      option.selected = false;
      option.style = 'all-filter-btn';
    });
    this.setState({ obilityOptions,clearBtnStyle });
    this.props.obilitySelectFunc([]);
  }

  //筛选条件点击事件
  selectClick = (e) => {
    let filterOptionList = [];
    let { obilityOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn';
    obilityOptions.map((option)=>{
      if (option.label === e.target.innerText) {
        if (option.selected) {
          option.selected = false;
          option.style = 'all-filter-btn';
        } else {
          option.selected = true;
          option.style = 'all-filter-btn selected-btn';
        }
      }
      if (option.selected) {
        filterOptionList.push(option);
      }
    });
    //‘不限’选项的样式控制
    if (filterOptionList.length === 0) {
      clearBtnStyle = 'all-filter-btn selected-btn';
    } else {
      clearBtnStyle = 'all-filter-btn';
    }
    this.setState({ obilityOptions,clearBtnStyle });
    this.props.obilitySelectFunc(filterOptionList);
  }

  //反选‘不限’
  disableAllSelected = () => {
    let clearBtnStyle = 'all-filter-btn selected-btn';
    this.setState({ clearBtnStyle });
  }

  //加载能力分类所有筛选按钮
  AllObilityOptionFunc = () => {
    let { obilityOptions,clearBtnStyle } = this.state;
    let res = [];
    res.push(
      <div key={`obility`} className={clearBtnStyle} onClick={this.delFilter}>
        <div>不限</div>
      </div>);
    obilityOptions.map((option)=>{
      res.push(<div key={`obility${option.value}`} className={option.style} onClick={this.selectClick}>{option.label}</div>);
      // if (option.selected) {
      //   clearBtnStyle = 'all-filter-btn selected-btn';
      // }
    });
    return res;
  }

  render() {
    return (
      this.AllObilityOptionFunc()
    );
  }
}

ObilityOptionsFilter.propTypes = {
  obilitySelectFunc: PropTypes.func
};

export default ObilityOptionsFilter;
