import React, { Component } from 'react';
import PropTypes from 'prop-types';
import RayMediaquery from 'ray-mediaquery';
import Logo from './Logo';
import MenuList from './MenuList';
import ExtraTools from './ExtraTools';

/**
 * 通用header
 *
 * @class Header
 * @extends {Component}
 */
class Header extends Component {

  constructor(props) {
    super(props);
    this.state = {
      activeHeight: 0,
      showText: true
    };
    this.expanded = false;
  }

  componentDidMount() {
    RayMediaquery.register('only screen and (min-width: 0) and (max-width: 992px)', {
      match: () => {
        this.setState({ showText: false });
      },
      unmatch: () => {
        this.setState({ showText: true });
      }
    });
  }

  onMouseOver = () => {
    // 未打开
    if (!this.expanded){
      this.expanded = true;
      this.toggleSubMenu(this.expanded);
    }
  }

  onMouseOut = () => {
    if (this.expanded){
      this.expanded = false;
      this.toggleSubMenu(this.expanded);
    }
  }

  toggleSubMenu = (flag) => {
    const { height } = this.props;
    const activeHeight = flag ? height : 0;
    this.setState({
      activeHeight
    });
  }

  render() {
    const { activeHeight, showText } = this.state;
    return (
      <div className="header">
        <div className="header-navs">
          <Logo {...this.props} showText={showText} />
          <MenuList
            {...this.props}
            height={activeHeight}
            showText={showText}
            toggleSubMenu={this.toggleSubMenu}
            onMenuOpen={this.onMouseOver}
            onMenuClosed={this.onMouseOut}
          />
          <ExtraTools {...this.props} showText={showText} />
        </div>
      </div>
    );
  }
}

Header.defaultProps = {
  height: 250
};

Header.propTypes = {
  height: PropTypes.number
};

export default Header;
