import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';

import { Switch, Scrollbars } from 'amos-framework';

import SkinItem from './SkinItem';

class Skin extends Component {

  static propTypes = {
    skins: PropTypes.array,
    onEyeModeChange: PropTypes.func,
    changeTheme: PropTypes.func,
    closed: PropTypes.func
  };

  static defaulProps = {
    changeTheme(){}
  };

  onThemeChange = (skin) => {
    this.props.changeTheme(skin);
  }

  closedSkin = () => {
    this.props.closed();
  }

  renderSkinContent = () => {
    const { skins = [] } = this.props;

    return skins.map(s =>(
      <SkinItem
        key={s.id}
        skinImg={s.icon}
        name={s.text}
        bgColor={s.bgColor}
        skinUse={s.skinUse}
        onThemeChange={() => this.onThemeChange(s)}
      />
    ));
  }

  render() {
    const { onEyeModeChange } = this.props;

    const skinContent = this.renderSkinContent();

    return (
      <div className="skin-scroll-wrapper">
        <Scrollbars>
          <div className="skin-wrapper">
            <div className="skin-header">
              <h3>皮肤</h3>
              <Icon icon="cross" onClick={this.closedSkin} />
            </div>
            <div className="skin-switch">
              <label className="switch-tip">护眼模式:</label>
              <Switch onLabel="开" offLabel="关" defaultOn onChange={onEyeModeChange} />
            </div>
            <div className="skin-content">
              {skinContent}
            </div>
          </div>
        </Scrollbars>
      </div>
    );
  }
}

export default Skin;
