export default function(skin){
  const rootDom = document.getElementById('app');
  rootDom.className = skin;
  const gbUrl = `/src/assets/skin/dark/bg-${skin}.jpg`;
  rootDom.style.backgroundImage = `url(${gbUrl})`;
  rootDom.style.backgroundRepeat = 'no-repeat';
  rootDom.style.backgroundSize = 'cover';
}

export const updateLinkCss = function(href, id = 'theme'){
  if (href && href.length >= 0){
    let themeLink = document.getElementById(id);
    if (themeLink){
      themeLink.setAttribute('href', href);
    } else {
      let link = document.createElement('link');
      link.setAttribute('rel', 'stylesheet');
      link.setAttribute('type', 'text/css');
      link.setAttribute('id', 'theme');
      link.setAttribute('href', href);
      let heads = document.getElementsByTagName('head');
      if (heads.length)  {
        heads[0].appendChild(link);
      } else {
        document.documentElement.appendChild(link);
      }
    }
  }
};


export const downloadFile = (url, fileName) => {
  let aLink = document.createElement('a');
  var evt = document.createEvent('MouseEvent');
  evt.initEvent('click', false, false);
  aLink.download = fileName;
  aLink.href = url;
  aLink.dispatchEvent(evt);
  if (navigator.userAgent.indexOf('Firefox') >= 0) {
    aLink.click();//FF的支持,可能不需要
  }
};
