import React, { Component } from 'react'; import PropTypes from 'prop-types';
import TableFilter from './TableFilter';
import './style/filter.scss';

class AmosFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      filter: {}
    };
  }

  getFilter = (dataIndex,value) => {
    let filter = this.state.filter;
    filter[dataIndex] = value;
    let res = {};
    let list = Object.keys(filter);
    list.map(e=>{
      let varName = filter[e];
      if (varName && varName !== '全部'){
        res[e] = varName;
      }
    });
    this.setState({ filter: res },this.props.changeFilters(res));
  }

  confirmClick = (value) => {
    this.props.closeFilter();
    this.getFilter();
  }

  cancelClick = () => {
    this.props.closeFilter();
  }


  render() {
    let columns = this.props.filterSearchModel.filter(e=>e.query === true);
    let columnsFilter = [];
    // let flag = false;
    columns.map((e)=>{
      columnsFilter.push(e);
      // if (e.primary){
      //   if (flag){
      //   } else {
      //     flag = true;
      //   }
      // } else {
      //   columnsFilter.push(e);
      // }
    });
    return (
      <div className='all-filter-content'>
        <div className='top-filter-content'>
          <TableFilter columns={columnsFilter} changeFilters={this.getFilter} />
        </div>
        {/*<hr />
        <div className='bottom-filter-oper'>
          <GridButton text='确定' onClick={this.confirmClick} />
          <GridButton className='grid-cancel-btn' text='取消' onClick={this.cancelClick} />
        </div>*/}
      </div>
    );
  }
}

AmosFilter.propTypes = {
  filterSearchModel: PropTypes.array,//表格列模型，默认值空数组
  changeFilters: PropTypes.func,//表格过滤条件变化方法，用于回调获取表格搜索条件
  closeFilter: PropTypes.func
};

export default AmosFilter;
