import React, { Component } from 'react'; import PropTypes from 'prop-types';
import { Button,Icon } from 'amos-antd';
import './style/filter.scss';

class MoreFilter extends Component {
  constructor(props) {
    super(props);
  }

  isTextSearch = () => {
    const { filterSearchModel } = this.props;
    const filter = filterSearchModel.filter((e)=>e.query === true);
    return filter;
  }

  render() {
    const primaryFilter = this.isTextSearch();
    const btnClass = this.props.showFilter ? 'open-more-ant-btn' : 'close-more-ant-btn';
    const display = primaryFilter.length > 1 ? 'block' : 'none';
    const style = { display };
    return (
      <div className='amos-more-filter-content' style={style}>
        <Button className={btnClass} onClick={this.props.openFilter}>筛选<Icon type='down' /></Button>
      </div>
    );
  }
}

MoreFilter.propTypes = {
  filterSearchModel: PropTypes.array,//表格列模型，默认值空数组
  openFilter: PropTypes.func,
  showFilter: PropTypes.bool
};

export default MoreFilter;
